;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/scrollable-num-entry.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/18 09:24:46 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;; scrollable-num-entry class - a numeric entry-field
;;;

;; Description of slots.
;;

(defclass scrollable-num-entry (collection-widget)
  ((increment
    :initarg :increment 
    :initform 1
    :type number
    :accessor increment)
   (lower-limit
    :initarg :lower-limit 
    :initform nil
    :type number
    :accessor lower-limit)
   (upper-limit
    :initarg :upper-limit 
    :initform nil
    :type number
    :accessor upper-limit)
   (entry
    :initarg :entry 
    :initform nil
    :type num-entry
    :reader entry)
   (gm :initform 'anchor-gm)))

(defmethod value ((self scrollable-num-entry))
  (value (entry self)))

(defmethod (setf value) (val (self scrollable-num-entry) &aux entry)
  (when (setq entry (entry self))
	(setf (value entry) val)))

(defun make-scrollable-num-entry (&rest args)
  (setf (getf args :scrollable) t)
  (apply #'make-num-entry args))

(defmethod new-instance ((self scrollable-num-entry)
			 &rest args
			 &aux entry)
  (call-next-method)
  (remf args :scrollable)
  (remf args :parent)
  (remf args :border-type)
  (remf args :label-type)
  (remf args :label)
  (remf args :label-x)
  (remf args :label-y)
  (remf args :border-width)
  (setf (getf args :parent) self)
  (setf (getf args :geom-spec) '(:anchor (:left 0 :right 34 :top 0 :bottom 0)))
  (setf (slot-value self 'entry) (setq entry (apply #'make-num-entry args)))
  (make-button 
   :parent self :value (make-image :file "pan-left.bitmap") 
   :geom-spec '(:anchor (:right 16 :top 0 :bottom 0))
   :pause-seconds .7
   :base-width 16
   :border-width 0
   :background "black"
   :foreground "white"
   :inverted-foreground "black"
   :inverted-background "white"
   :press-func `(sne-decr ',self))
  (make-button 
   :parent self :value (make-image :file "pan-right.bitmap") 
   :pause-seconds .7
   :background "black"
   :foreground "white"
   :inverted-foreground "black"
   :inverted-background "white"
   :base-width 16
   :border-width 0
   :geom-spec '(:anchor (:right 0 :top 0 :bottom 0))
   :press-func `(sne-incr ',self)))

(defun sne-decr (self)
  (let ((incr (increment self))
	(ll (lower-limit self))
	(val (value self)))
       (if (or (null ll) (>= (- val incr) ll))
	   (decf (value self) incr))))

(defun sne-incr (self)
  (let ((incr (increment self))
	(ul (upper-limit self))
	(val (value self)))
       (if (or (null ul) (<= (+ val incr) ul))
	   (incf (value self) incr))))

