;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/num-entry.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/18 09:24:36 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;; num-entry class - a numeric entry-field
;;;

;; Description of slots.
;;

(defclass num-entry (entry-widget)
  ())

(defun make-num-entry (&rest keys &key scrollable &allow-other-keys &aux wtype) 
  (setq wtype (if scrollable 'scrollable-num-entry 'num-entry)) 
  (remf keys :scrollable)
  (apply #'make-instance wtype :allow-other-keys t keys))

;;;
;;; num-entry only handles integers, period, and minus sign.
;;;

(defevents num-entry
  ((:key-press :detail #\0) (text-widget char-handler))
  ((:key-press :detail #\1) (text-widget char-handler))
  ((:key-press :detail #\2) (text-widget char-handler))
  ((:key-press :detail #\3) (text-widget char-handler))
  ((:key-press :detail #\4) (text-widget char-handler))
  ((:key-press :detail #\5) (text-widget char-handler))
  ((:key-press :detail #\6) (text-widget char-handler))
  ((:key-press :detail #\7) (text-widget char-handler))
  ((:key-press :detail #\8) (text-widget char-handler))
  ((:key-press :detail #\9) (text-widget char-handler))
  ((:key-press :detail #\.) (text-widget char-handler))
  ((:key-press :detail #\-) (text-widget char-handler)))

(defmethod value ((self num-entry)
		  &key 
		  (key-dummy nil)
		  &allow-other-keys)
  (read-from-string (value (buffer self)) nil))

(defmethod (setf value) (val (self num-entry))
  (typecase val
	    (number
	     (new self)
	     (put self (princ-to-string val) :repaint nil)
	     (setf (column self) 0))
	    (string
	     (if (numberp (read-from-string val))
		 (progn
		  (new self)
		  (put self val :repaint nil)
		  (setf (column self) 0))
		 (warn "num.setf.value: Illegal value ~S" val)))
	    (null 
	     (new self)
	     (setf (column self) 0))
	    (t
	     (warn "num.setf.value: Illegal value ~S" val))))

(defhandler beep ((self num-entry) &rest args
		  &default :key-press)
  (declare (ignore args))
  (xlib:bell (res (display self))))
