;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/data-utils.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/18 09:20:04 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;; 	Functions, macros, and methods to return an element in the given 
;;;	portal, array, or list
;;;

(defmethod element ((self list) n)
  (elt self n))

(defmethod (setf element) (val (self list) n)
  (setf (elt self n) val))

(defmethod element ((self pgclos::portal) n)
  (aref (slot-value self 'array) n))

(defmethod element ((self array) n)
  (aref self n 0))

(defmethod (setf element) (val (self array) n)
  (setf (aref self n 0) val))

(defun nth-element (n struct &key slot)
  (if (listp struct)
      (nth n struct)
      (if slot
	  (slot-value struct slot)
	  (slot-value struct (pcl::slotd-name (nth n (pcl::class-slots 
						      (pcl::class-of 
						       struct))))))))

(defmethod entry ((self array) row col)
  (aref self row col))

(defmethod entry ((self pgclos::portal) row col &aux tup)
  (setq tup (aref (slot-value self 'array) row))
  (slot-value tup (pcl::slotd-name (nth col (pcl::class-slots
					     (pcl::class-of tup))))))

(defmethod set-entry ((self array) row col new-val)
  (setf (aref self row col) new-val))

(defmethod set-entry ((self pgclos::portal) row col new-val)
  (warn "Can't do data-base operations yet. . ."))

(defun matrix-field-p (self)
  (typep self 'matrix-field))

(defmethod num-elements ((self pgclos::portal))
  (slot-value self 'count))

(defmethod num-elements ((self array))
  (array-dimension self 0))

(defmethod num-elements ((self list))
  (length self))

(defmethod num-cols ((self array))
  (array-dimension self 1))

(defmethod num-cols ((self list))
  (length (car self)))

(defmethod num-cols ((self pgclos::portal))
  (length (pcl::class-slots (pcl::class-of (aref (slot-value self 'array) 0)))))

