;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/enclosure-widget.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/18 09:16:08 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;; an enclosure widget is just a collection which holds a gadget.
;;; it's chief use is to get a gadget to receive events.
;;;

(defclass enclosure-widget (collection-widget)
  ())

(defun make-enclosure-widget (&rest args)
  (apply #'make-instance 'enclosure-widget :allow-other-keys t args))

;;;
;;; value method and setf just refer to enclosed gadget
;;;

(defmethod value ((self enclosure-widget) &aux ch)
  (when (setq ch (children self))
	(value (car ch))))

(defmethod (setf value) (val (self enclosure-widget) &aux ch)
  (when (setq ch (children self))
	(setf (value (car ch)) val)))

