;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/arb-widget.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/18 09:15:14 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;; arb-widget class
;;;

(defclass arb-widget (widget)
  ((value :type t :initarg :value  :initform nil :accessor value)))

(defun make-arb-widget (&rest args &key (children nil) (value nil)
			      &allow-other-keys)
  (if children
      (apply #'make-collection-widget args)
      (apply #'make-instance (determine-widget-class value)
	     :allow-other-keys t args)))

(defmacro arb-widget-p (self)
  "determine if this object is a widget"
  `(typep ,self 'widget))

;; (defmethod (setf value) (value (self widget))
;;  (setf (slot-value self 'value) value)
;;   (change-class self (determine-class self value)))

(defmethod update-instance-for-different-class :after ((old window)
						       (new arb-widget))
  (if (null (class-event-map new))
      (make-class-event-map new))
  (if (null-widget-p new)
      (setf (value new) nil)
      (setf (value new) (value new))))

;;;
;;;	Methods to determine correct subclass
;;;

(defmethod determine-class ((self arb-widget) value)
  (determine-widget-class value))

(defmethod determine-widget-class ((value null))
  'null-widget)

(defmethod determine-widget-class ((value string))
  'text-widget)

(defmethod determine-widget-class ((value image))
  'image-widget)

(defmethod determine-widget-class ((value (eql :up))) 'arrow-widget)
(defmethod determine-widget-class ((value (eql :down))) 'arrow-widget)
(defmethod determine-widget-class ((value (eql :left))) 'arrow-widget)
(defmethod determine-widget-class ((value (eql :right))) `arrow-widget)

(defmethod determine-widget-class ((value list))
  (cond ((eq (car value) 'image) 'image-widget)
	((stringp (car value)) 'text-widget)
	(t (warn "widget.determine-class, unable
		 to determine class!~%")
	   'null-widget)))

(defmethod determine-widget-class ((value t))
  (t (warn "widget.determine-class, unable to
	   determine class!~%")
     'null-widget))

;;;
;;; Definition of the null-widget class
;;;

(defclass null-widget (widget) ())
(defun make-null-widget (&rest keys)
    (apply #'make-instance 'null-widget :allow-other-keys t keys))

(defun null-widget-p (self)
  "determine if this object is a null-widget"
  (typep self 'null-widget))

(defmethod (setf value) ((value null) (self null-widget)) nil)

