;;; 
;;; Copyright (c) 1990 Regents of the University of California
;;;
;;; $Author: picasso $
;;; $Source: RCS/menu.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/18 09:11:19 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;;	New-instance method
;;;

(defmethod new-instance ((self menu-button)
			 &key
			 (menu nil)
			 &allow-other-keys)
  (call-next-method)
  (if menu (setf (menu menu) self)))

(defmethod do-attach ((self menu-button))
  (call-next-method)
  (if (menu self) (attach (menu self))))

(defmethod do-make-invisible ((self menu-button)
			      &key (ignore nil)
			      &allow-other-keys)
  (when (and (menu self) (exposed-p (menu self)))
	(conceal (menu self))
	(setf (bring-back self) t))
  (call-next-method))

(defmethod do-make-uninvisible ((self menu-button)
				&key (ignore nil)
				&allow-other-keys)
  (when (bring-back self)
	(setf (bring-back self) nil)
	(expose (menu self)))
  (call-next-method))

(defmethod dimmed ((self menu-button))
  (or (call-next-method) (null (menu self)) (zerop (num-cells (menu self)))
      (exposed-p (menu self))))

(defmethod (setf menu) (value (self menu-button))
  (if (menu self)
      (setf (menu (menu self)) nil))
  (setf (slot-value self 'menu) value)
  (if value
      (setf (menu value) self))
  (repaint self))

(defhandler cross ((self menu-button) &rest args
		   &default ((:enter-window :detail :left-button) 
			     (:enter-window :detail :middle-button)
			     (:enter-window :detail :right-button)))
  (apply #'menu-button-activate args)
  (apply #'menu-button-select args))

(defhandler select ((self menu-button) &rest event
		    &default :button-press)
  (if (dimmed self)
      (return-from menu-button-select))
  (if (menu self)
      (activate-pull-down-menu (menu self) self event)))

(defhandler deselect ((self menu-button) &rest event
		      &default :button-release)
  (declare (ignore self event)))

(defhandler activate ((self menu-button) &rest event
		      &default :enter-window)
  (unless (dimmed self)
	  (setf (inverted self) t))
  (when (pushed self) (apply #'menu-button-select (cons self event)))
  (setf (pushed self) nil))

(defhandler deactivate ((self menu-button) &rest event
			&default :leave-window)
  (declare (ignore event))
  (unless (dimmed self)
	  (setf (inverted self) nil)))

(defmethod resize-window-handler ((self menu-button))
  (call-next-method)
  (if (menu self)
      (resize-hint-changed (menu self))))

(defmethod do-repaint ((self menu-button))
  (apply #'put (slot-value self 'value)))
