;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: RCS/menu-entry.cl,v $
;;; $Revision: 1.3 $
;;; $Date: 90/07/24 17:27:23 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;; (load "menu-defclasses")

;;; THE DEFCLASS FOR MENU-ENTRY CAN BE FOUND IN menu-defclasses.cl


;;;
;;; accessor methods for menu-entry
;;;

(defun add-me (me sup)
  (push me (slot-value sup 'synths)))
(defsetf me-parent add-me)

(defun me-left (me)
  (getf me :left))

(defun set-me-left (me val)
  (if (synth-p (getf me :left))
      (setf (car (getf me :left)) val)
      (setf (getf me :left) val)))
(defsetf me-left set-me-left)

(defun me-center (me)
  (getf me :center))

(defun set-me-center (me val)
  (if (synth-p (getf me :center))
      (setf (car (getf me :center)) val)
      (setf (getf me :center) val)))
(defsetf me-center set-me-center)

(defun me-right (me)
  (getf me :right))

(defun set-me-right (me val)
  (if (synth-p (getf me :right))
      (setf (car (getf me :right)) val)
      (setf (getf me :right) val)))
(defsetf me-right set-me-right)

(defun me-font (me)
  (getf me :font))

(defun set-me-font (me val)
  (setf (getf me :font) val))
(defsetf me-font set-me-font)

(defun me-dimmed (me)
  (getf me :dimmed))

(defun set-me-dimmed (me value)
  (setf (getf me :dimmed) value) 
  (setf (getf (cdr (me-left me)) :dimmed) value)
  (setf (getf (cdr (me-center me)) :dimmed) value)
  (setf (getf (cdr (me-right me)) :dimmed) value))
(defsetf me-dimmed set-me-dimmed)

(defun show-me (me)
  (setf (getf me :exposed) t))

(defun hide-me (me)
  (setf (getf me :exposed) nil))

(defun remove-me (me pane)
  (setf (slot-value pane 'synths)
	(delete me (slot-value pane 'synths))))

(defun me-invert (me pane-res gc width &aux synth)
  (if (null me) (return-from me-invert))
  (setq synth (me-left me))
  (xlib:draw-rectangle pane-res gc 
		       1 (getf me :y) 
		       (- width *menu-shadow-thickness* 2) 
		       (getf me :height) t)
  (apply #'put (cons (car synth) (append '(:inverted t) (cdr synth))))
  (setq synth (me-center me))
  (apply #'put (cons (car synth) (append '(:inverted t) (cdr synth))))
  (setq synth (me-right me))
  (apply #'put (cons (car synth) (append '(:inverted t) (cdr synth)))))

(defun me-uninvert (me pane-res gc-clear width)
  (if (null me) (return-from me-uninvert))
  (xlib:draw-rectangle pane-res gc-clear 1 (getf me :y)
		       (- width *menu-shadow-thickness* 2) (getf me :height) t)
  (apply #'put (me-left me))
  (apply #'put (me-center me))
  (apply #'put (me-right me)))

;;;
;;;	Attach a menu-entry
;;;

(defun me-attach (me &aux synth window me-info fg bg)
  ;; Make gc-dimmed
  ;; Attach left
  (setq synth (me-left me))
  (setq window (getf (cdr synth) :window))
  (setq me-info (cdar synth))
  (setf (getf (cdr (getf me :left)) :gc) (make-shared-gc window me-info)
	(getf (cdr (getf me :left)) :me-info) me-info)
  ;; make dimmed gc
  (setq me-info (copy-list me-info))
  (setf (getf me-info :paint) "gray50")
  (if (black-and-white-display-p (display window))
      (setf (getf me-info :function) 8))
  (setf (getf (cdr (getf me :left)) :gc-dimmed) 
	(make-shared-gc window me-info))
  (rplaca (getf me :left) (caar synth))
  ;; Make inverted gc
  (setq me-info (copy-list me-info))
  (setq bg (getf me-info :background)
	fg (getf me-info :foreground))
  (unless bg (setq bg "black"))
  (unless fg (setq fg "white"))
  (setf (getf me-info :background) bg)
  (setf (getf me-info :foreground) fg)
  (setf (getf (cdr (getf me :left)) :gc-invert) 
	(make-shared-gc window me-info))
  
  ;; Attach center
  (setq synth (me-center me))
  ;;  (when flag (format t "synth: ~s~%" synth) (setq flag nil))
  (setq window (getf (cdr synth) :window))
  (setq me-info (cdar synth))
  (setf (getf (cdr (getf me :center)) :gc) (make-shared-gc window me-info)
	(getf (cdr (getf me :center)) :me-info) me-info)
  (rplaca (getf me :center) (caar synth))
  ;; make dimmed gc
  (setq me-info (copy-list me-info))
  (setf (getf me-info :paint) "gray50")
  (if (black-and-white-display-p (display window))
      (setf (getf me-info :function) 8))
  (setf (getf (cdr (getf me :center)) :gc-dimmed) 
	(make-shared-gc window me-info))
  ;; Make inverted gc
  (setq me-info (copy-list me-info))
  (setq bg (getf me-info :background)
	fg (getf me-info :foreground))
  (unless bg (setq bg "black"))
  (unless fg (setq fg "white"))
  (setf (getf me-info :background) bg)
  (setf (getf me-info :foreground) fg)
  (setf (getf (cdr (getf me :center)) :gc-invert) 
	(make-shared-gc window me-info))
  
  ;; Attach right
  (setq synth (me-right me))
  (setq window (getf (cdr synth) :window))
  (setq me-info (cdar synth))
  (setf (getf (cdr (getf me :right)) :gc) (make-shared-gc window me-info)
	(getf (cdr (getf me :right)) :me-info) me-info)
  (rplaca (getf me :right) (caar synth))
  ;; make dimmed gc
  (setq me-info (copy-list me-info))
  (setf (getf me-info :paint) "gray50")
  (if (black-and-white-display-p (display window))
      (setf (getf me-info :function) 8))
  (setf (getf (cdr (getf me :right)) :gc-dimmed) 
	(make-shared-gc window me-info))
  ;; Make inverted gc
  (setq me-info (copy-list me-info))
  (setq bg (getf me-info :background)
	fg (getf me-info :foreground))
  (unless bg (setq bg "black"))
  (unless fg (setq fg "white"))
  (setf (getf me-info :background) bg)
  (setf (getf me-info :foreground) fg)
  (setf (getf (cdr (getf me :right)) :gc-invert) 
	(make-shared-gc window me-info))

  me)

;;;
;;;	Detach a menu-entry
;;;

(defun me-detach (me &aux synth)
  ;; Detach left
  (setq synth (me-left me))
  (rplaca (getf me :left) (cons (car synth) (getf (cdr synth) :me-info)))
  (remf (cdr (getf me :left)) :gc)
  (remf (cdr (getf me :left)) :me-info)

  ;; Detach center
  (setq synth (me-center me))
  (rplaca (getf me :center) (cons (car synth) (getf (cdr synth) :me-info)))
  (remf (cdr (getf me :center)) :gc)
  (remf (cdr (getf me :center)) :me-info)

  ;; Detach right
  (setq synth (me-right me))
  (rplaca (getf me :right) (cons (car synth) (getf (cdr synth) :me-info)))
  (remf (cdr (getf me :right)) :gc)
  (remf (cdr (getf me :right)) :me-info)
  me)

;;;
;;; new-instance method for menu-entry
;;;
(defun default-menu-fxn (self) (declare (ignore self)) t)

(defun make-menu-entry (&key
			(left nil)
			(center nil)
			(right nil)
			(left-font nil)
			(right-font nil)
			(center-font nil)
			(font (get-font))
			(code nil)
			(dimmed nil)
			(status nil)
			(left-status nil)
			(center-status nil)
			(right-status nil)
			(parent nil)
			&allow-other-keys
			&aux self)
  (setq status 
	(if (eq status :concealed) nil t))

  (setq left-status
	(if left-status
	    (if (eq left-status :concealed) nil t)
	    status))
  (setq center-status
	(if center-status
	    (if (eq center-status :concealed) nil t)
	    status))
  (setq right-status
	(if right-status
	    (if (eq right-status :concealed) nil t)
	    status))

  ;;  Coerce values to synthetic gadgets
  (unless (synth-p left)
	  (setq left (list left)))
  (unless (synth-p center)
	  (setq center (list center)))
  (unless (synth-p right)
	  (setq right (list right)))

  ;;  Initialize pseudo-synthetic gadgets
  (setq left (list left :window parent :exposed status :vert-just :center 
		    :horiz-just :left :dimmed dimmed :font nil))
  (setq center (list center :window parent :exposed status :vert-just :center 
		     :horiz-just (if (and parent
					  (center-left-justified parent))
				     :left :center) :dimmed dimmed :font nil))
  (setq right (list right :window parent :exposed status :vert-just :center 
		    :horiz-just :left :dimmed dimmed :font nil))

  (if left (setf (getf self :left) left))
  (if right (setf (getf self :right) right))
  (if center (setf (getf self :center) center))
  
  (cond ((font-p font))
	((stringp font) (font-attach (setq font (make-font :name font))))
	((or (stringp left) (stringp center) (stringp right))
	 (setq font (get-font)))
	(t (setq font (get-font))))

  (if (stringp left-font) (setq left-font (make-font :name left-font)))
  (if (stringp center-font) (setq center-font (make-font :name center-font)))
  (if (stringp right-font) (setq right-font (make-font :name right-font)))

  (when (or (font-p left-font) (stringp (caar left)))
	(unless left-font (setq left-font font))
	(font-attach left-font)
	(setf (getf (cdar (me-left self)) :font) left-font))
  
  (when (or (font-p center-font) (stringp (caar center)))
	(unless center-font (setq center-font font))
	(font-attach center-font)
	(setf (getf (cdar (me-center self)) :font) center-font))
  
  (when (or (font-p right-font) (stringp (caar right)))
	(unless right-font (setq right-font font))
	(font-attach right-font)
	(setf (getf (cdar (me-right self)) :font) right-font))

  (setf (getf self :window) parent
	(getf self :dimmed) dimmed
	(getf self :exposed) status
	(getf self :height) 0
	(getf self :code) code
	(getf self :y) 0)
  
  (setf (me-parent self) parent)
  self)
