;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: seitz $
;;; $Source: RCS/menu-defclasses.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 90/07/27 15:04:34 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;  this file contains the defclasses for menus to allow the methods for
;;;  each component class to specialize on any menu class.

;;;
;;;  Menu entries provide all of the needed data for constructing a single
;;;  entry in a menu.  Such an entry can have text or a pixmap in the 
;;;  center, as well as on the left and right.  In addition to this information,
;;;  the menu entry caches height and width information about its components, 
;;;  and may even cache a bitmap of the pane for easier storage.  Also, the
;;;  menu entry indicates a function to call should the menu item be selected
;;;  along with an optional argument.  Finally, some attributes, such as
;;;  dimmed, are stored in the entry--others, such as walks and checked, are
;;;  methods which operate on the text and pixmaps.
;;;

;;;
;;;  menu pane defclass defines a menu pane as an opaque window with 
;;;  the following slots of interest:
;;;
;;;  saved-pixmap -- the pixmap of the area over which the menu pane is 
;;;		     displayed, saved to be returned to the screen without
;;;		     generating expose events.
;;;
;;;  ptab -- pixel table, maps screen position to menu entry
;;;  l,r,cwidth -- indicators of the width of each part of the menu
;;;  center-left-justified -- boolean as to whether menu center col is lj
;;;  menu -- back pointer to parent menu

(defclass menu-pane (collection-widget)
  ((name :initform "A Menu Pane" :type string :accessor name)
   (tearable :initarg :tearable :initform t :type atom :accessor tearable)
   (repack-on-stat :initarg :repack-on-stat :initform nil)
   (ptab :initarg :ptab :initform nil :type vector :accessor ptab)
   (parent :initform (root-window))
   (status :initform :concealed)
   (gm :initform 'menu-gm)
   (gm-data :initform '(2 4 2))
   (width-increment :initform 0)
   (height-increment :initform 0)
   (conform :initform :grow-shrink)
   (center-left-justified 
    :initarg :center-left-justified  
    :initform nil 
    :type atom 
    :accessor center-left-justified)
   (event-mask :initform '(:enter-window :leave-window :button-press 
			   :button-release :pointer-motion
			   :visibility-change)
	       :type list :accessor event-mask)
   (menu :initarg :menu :initform nil :type menu :accessor menu)
   (current-cell :initform nil :type t)
   (attach-when-possible :initform t)
   (gc-spec :initform '((gc-res "default")
			(gc-shadow (:paint "gray25"))
			(gc-clear (:foreground "white"))))
   (gc-shadow :type vector :reader gc-shadow)
   (gc-clear :type vector :reader gc-clear)
   (background :initform nil)
   (border-width :initform 0)
   
   ;; synthetic gadget info
   (synths :initarg :synths :initform nil :type list :reader synths)
   (synth-data :initarg :synth-data :initform nil :type list)))

(defun make-menu-pane (&rest keys)
  (apply #'make-instance 'menu-pane :allow-other-keys t keys))

;;; menu-button def

(defclass menu-button (gray-button)
  ((menu :initarg :menu :initform nil :type menu-pane :accessor menu)
   (bring-back 
    :initarg :bring-back 
    :initform nil 
    :type atom 
    :accessor bring-back)
   (font :initform "8x13")
   (border-width :initform 1)
   (invert-width :initform 3)))

(defun make-menu-button (&rest keys)
  (apply #'make-instance 'menu-button :allow-other-keys t keys))


(defmacro menu-button-p (self)
  `(typep ,self 'menu-button))

(defclass menu-bar (collection-gadget)
  ((base-height :initform 40)
   (border-type :initform :box)
   (border-width :initform 1)
   (geom-spec :initform :top)
   (gm :initform 'just-pack-gm)))

(defun make-menu-bar (&rest keys)
  (apply #'make-instance 'menu-bar :allow-other-keys t keys))

(defmacro menu-bar-p (self)
  (typep self 'menu-bar))
