;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: seitz $
;;; $Source: RCS/paint-gadget.cl,v $
;;; $Revision: 1.3 $
;;; $Date: 90/07/31 12:53:04 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;;	A paint-gadget displays an arbitrary paint (a color or image)
;;;	Images are tiled instead of put.
;;;

;;;
;;; Definition of the paint-gadget class
;;;

(defclass paint-gadget (gadget)
  ((gc-spec :initform '(gc-res "default"))))

(defun make-paint-gadget (&rest keys)
  (apply #'make-instance 'paint-gadget :allow-other-keys t keys))

(defmethod (setf value) (val (self paint-gadget))
  (setf (slot-value self 'value) val)
  (setf (background self) val)
  (repaint self))

(defmethod do-repaint ((self paint-gadget))
  (clear self))
