;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: seitz $
;;; $Source: RCS/image-gadget.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 90/07/26 13:59:17 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;; Definition of the image-gadget class
;;;

(defclass image-gadget (gadget)
  (
   ;; These control from what part of the image is displayed.
   (src-x
    :initarg :src-x 
    :initform 0
    :type integer
    :accessor src-x)
   (src-y
    :initarg :src-y 
    :initform 0
    :type integer
    :accessor src-y)
   (src-width
    :initarg :src-width 
    :initform nil
    :type integer
    :accessor src-width)
   (src-height
    :initarg :src-height 
    :initform nil
    :type integer
    :accessor src-height)
   (bitmap-p
    :initform nil
    :type atom
    :reader bitmap-p)

   ;; Standard justification information.
   (horiz-just
    :initarg :horiz-just 
    :initform :center
    :type keyword
    :accessor horiz-just)
   (vert-just
    :initarg :vert-just 
    :initform :center
    :type keyword
    :accessor vert-just)
   (gc-spec :initform '(gc-res "default"))))

(defun make-image-gadget (&rest keys)
  (apply #'make-instance 'image-gadget :allow-other-keys t keys))

(defmethod (setf value) ((value image) (self image-gadget))
  (setf (slot-value self 'value) value 
	(src-x self) 0
	(src-y self) 0
	(src-width self) (width value)
	(src-height self) (height value)
	(slot-value self 'bitmap-p) (bitmap-p value))
  (setf (resize-hint self) (list (src-width self) (src-height self) 1 1 nil))
  (repaint self))

(defmethod do-repaint ((self image-gadget))
  (if (value self)
  (let* ((image (value self))
	 (image-width (width image))
	 (image-height (height image))
	 (src-x (src-x self))
	 (src-y (src-y self))
	 (src-width (min image-width (src-width self)))
	 (src-height (min image-height (src-height self)))
	 (vert-just (vert-just self))
	 (horiz-just (horiz-just self))
	 (dst-x (+ (repaint-x self)
		   (case horiz-just
			 (:left 0)
			 (:center (round (/ (- (width self) image-width) 2)))
			 (:right (- (width self) image-width)))))
	 (dst-y (+ (repaint-y self)
		   (case vert-just
			 (:top 0)
			 (:center (round (/ (- (height self) image-height) 2)))
			 (:bottom (- (height self) image-height))))))
	(if (dimmed self)
	    (draw-gray-image (res self) (gc-res self) (res image) dst-x dst-y
			     :src-x src-x :src-y src-y 
			     :w src-width :h src-height 
			     :bitmap-p (bitmap-p self))
	    (xlib:put-image (res self) (gc-res self) (res image) 
			    :x dst-x :y dst-y :src-x src-x :src-y src-y 
			    :width src-width :height src-height
			    :bitmap-p (bitmap-p self))))))

;;;  when changing a different gadget to image gadget, reset the justification
(defmethod update-instance-for-different-class :after
  ((old gadget) (new image-gadget))
  (setf (vert-just new) :center)
  (setf (horiz-just new) :center)
  (when (exposed-p new) (repaint new)))

