;;;
;;; Copyright (c) 1990 Regents of the University of California
;;;
;;; Definition for segments, a subclass of 2d-shapes to describe
;;; graphic objects that can be drawn as a sequence of lines.
;;;
;;; Segments give a 2d-shape various graphic attributes, such as
;;; color, line-width and line-style.
;;;

(in-package 'pt :use '(lisp pcl))

;;;
;;; Are we a segment? Isn't that special!
;;;
(defun segment-p (self)
  (typep self 'segment))

;;;
;;; Class definition for segment
;;;
(defclass segment (2d-shape)
  ((color :initarg :color :initform "white" :type t :reader color)
   (line-width 
    :initarg :line-width 
    :initform 0
    :type integer 
    :reader line-width)
   (line-style 
    :initarg :line-style 
    :initform :solid 
    :type integer 
    :reader line-style)))


(defmethod (setf color) (value (self segment))
  (unless (eq value (color self))
	  (setf (slot-value self 'color) value)
	  (notify-gc-change self)))

(defmethod (setf line-width) (value (self segment))
  (unless (eq value (line-width self))
	  (setf (slot-value self 'line-width) value)
	  (notify-gc-change self)))

(defmethod (setf line-style) (value (self segment))
  (unless (eq value (line-style self))
	  (setf (slot-value self 'line-style) value)
	  (notify-gc-change self)))
