;;;
;;; Copyright (c) 1990 Regents of the University of California
;;;
;;; Definition for line-segment, a subclass of shapes.
;;;
;;; Lines are types of shapes who control points are the endpoints
;;; of the line-segment.
;;;

(in-package 'pt :use '(lisp pcl))

;;;
;;; Are we a line-segment? Isn't that special!
;;;
(defmacro line-segment-p (self)
  `(typep ,self 'line-segment))

;;;
;;; Class definition for line-segment
;;;
(defclass line-segment (polygon)
  ((closed :initform nil)))

(defun make-line-segment (&rest keys)
  (apply #'make-instance (cons 'line-segment keys)))

(defmethod (setf start-pt) (pt (self line-segment))
  (2dv-copy (hook-pt self) pt))

(defmethod (setf end-pt) (pt (self line-segment))
  (2dv-copy (car (ctrl-pts self)) pt)
  (notify-geom-change self))

(defmethod start-pt ((self line-segment))
  (hook-pt self))

(defmethod end-pt ((self line-segment))
  (car (ctrl-pts self)))

(defmethod new-instance ((self line-segment)
			 &key
			 (ignore nil)
			 &allow-other-keys)
  (call-next-method)
  (setf (slot-value self 'coord-list) (make-array '(2) :fill-pointer 0))
  (setf (slot-value self 'ctrl-pts) (list (make-2d-point :x 0.0 :y 0.0)))
  self)

(defmethod 2d-coord-list ((self line-segment) xleft xright ybottom ytop w h)
  (declare (ignore w h))
  (let* ((p1 (start-pt self))
	 (p2 (end-pt self))
	 (x1 (2d-point-x p1))
	 (y1 (2d-point-y p1))
	 (x2 (2d-point-x p2))
	 (y2 (2d-point-y p2))
	 (rv (slot-value self 'coord-list)))
	(setf (aref rv 0) (alloc-2d x1 y1)
	      (aref rv 1) (alloc-2d x2 y2)
	      (fill-pointer rv) 2)
	rv))
