;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; Utility routines for graphic widgets.
;;;
;;; $Author: bsmith $
;;; $Source: RCS/grf-utils.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 90/07/25 13:05:50 $
;;;

(in-package 'pt :use '(pcl lisp))

(defun get-region (window x1 y1 
			  &key
			  (cursor (default-cursor))
			  (fg "white")
			  (gc nil))
  "Get a region in the specified window.  Assumes the mouse has been pressed
  at (x1, y1) and is being dragged to a box.  This function will return two
  values, (x2, y2) corresponding to where the mouse is dropped."
  (grab-mouse window :cursor cursor 
	      :event-mask '(:button-release :pointer-motion))
  (when (stringp fg)
	(if (get-color fg)
	    (setq fg (get-color fg))
	    (setq fg (make-color :name fg))))
  (if (null gc)
      (setq gc (make-gc window `(:foreground ,fg))))
  (let* ((res (res window))
	 (x2 (1+ x1))
	 (y2 (1+ y1))
	 (d (xlib:drawable-depth res))
	 (w (width window))
	 (h (height window))
	 (tpm (xlib:create-pixmap :width w :height 1 :depth d :drawable res))
	 (bpm (xlib:create-pixmap :width w :height 1 :depth d :drawable res))
	 (lpm (xlib:create-pixmap :width 1 :height h :depth d :drawable res))
	 (rpm (xlib:create-pixmap :width 1 :height h :depth d :drawable res))
	 (bw 1)
	 (bh 1))
       ;; Get the saved pixmaps
       (xlib:copy-area res gc 0 y1 w 1 tpm 0 0)
       (xlib:copy-area res gc x1 0 1 h lpm 0 0)
       (xlib:copy-area res gc x1 y2 (1+ bw) 1 bpm 0 0)
       (xlib:copy-area res gc x2 y1 1 (1+ bh) rpm 0 0)
       ;; draw the box
       (xlib:draw-rectangle res gc x1 y1 bw bh)
       ;; start processing -- drag and wait for button-released
       (block event-loop
	      (event-loop :handler
#'(lambda (&rest args &key x y event-key &allow-other-keys)
	  (cond ((eq event-key :motion-notify)
		 ;; Restore contents of screen
		 (xlib:copy-area tpm gc 0 0 w 1 res 0 y1)
		 (xlib:copy-area lpm gc 0 0 1 h res x1 0)
		 (xlib:copy-area bpm gc 0 0 (1+ (abs bw)) 1 res (min x1 x2) y2)
		 (xlib:copy-area rpm gc 0 0 1 (1+ (abs bh)) res x2 (min y1 y2))
		 ;; Update x2, y2, bw and bh
		 (setq x2 x y2 y)
		 (setq bw (- x2 x1)
		       bh (- y2 y1))
		 ;; Get copy of contents under new position
		 (xlib:copy-area res gc (min x1 x2) y2 (1+ (abs bw)) 1 bpm 0 0)
		 (xlib:copy-area res gc x2 (min y1 y2) 1 (1+ (abs bh)) rpm 0 0)
		 ;; Draw the new box
		 (xlib:draw-rectangle res gc
				      (min x2 x1) (min y2 y1)
				      (abs bw) (abs bh)))
		((eq event-key :button-release)
		 ;; Restore contents of screen
		 (xlib:copy-area tpm gc 0 0 w 1 res 0 y1)
		 (xlib:copy-area lpm gc 0 0 1 h res x1 0)
		 (xlib:copy-area bpm gc 0 0 (1+ (abs bw)) 1 res (min x1 x2) y2)
		 (xlib:copy-area rpm gc 0 0 1 (1+ (abs bh)) res x2 (min y1 y2))
		 (setq x2 x y2 y)
		 (return-from event-loop))
		(t
		 (apply #'dispatch-event args)))
	  nil)))
       ;; Free the created gc
       (xlib:free-gcontext gc)
       (xlib:free-pixmap tpm)
       (xlib:free-pixmap bpm)
       (xlib:free-pixmap lpm)
       (xlib:free-pixmap rpm)
       ;; ungrab mouse
       (ungrab-mouse)
       ;; return position of release
       (values x2 y2)))
