;;;
;;; Copyright (c) 1990 Regents of the University of California
;;;
;;; Definition for display-list, an abstract class for caching maps
;;; from device-independent reps do device-dependent reps.
;;;

(in-package 'pt :use '(lisp pcl))

;;;
;;; Are we a display-list? Isn't that special!
;;;
(defmacro display-list-p (self)
  `(typep ,self 'display-list))

;;;
;;; Class definition for display-list
;;;
(defclass display-list ()
  ((valid :initarg :valid :initform nil :reader valid)
   (shape :initarg :shape :initform nil :reader shape)
   (visible :initarg :visible :initform t :accessor visible)
   (prop-list :initarg :prop-list :initform nil :reader prop-list)
   (draw-gc :initarg :draw-gc :initform nil :accessor draw-gc)
   (erase-gc :initarg :erase-gc :initform nil :accessor erase-gc)))

(defmacro validate (dl mapper)
  `(unless (valid ,dl) 
	   (do-validation ,dl ,mapper)
	   (setf (slot-value ,dl 'valid) t)))

(defmacro invalidate (dl)
  `(setf (slot-value ,dl 'valid) nil))
