;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/panel.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 90/07/22 14:21:11 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;
;;  OVERVIEW
;;
;; a panel is very much like a form, except that it is run out of the root
;; window rather than as a part of a frame, and that many panels can run at
;; once.
;;

;;;
;;;  	Define panel class
;;;

(defclass panel (top-level-po callable-po)
  (
   ;; Inherited slots with overridden defaults

   (conform :initform :grow-shrink)
   (background :initform "gray75")
   (event-mask :initform '(:exposure :enter-window :leave-window :key-press
				     :structure-notify))
   (gm :initform 'packed-gm)

   ;; Title to be displayed in title bar

   (title :initarg :title :initform "Panel" :type string :reader title)

   ;; Special slots to handle iconifying and deiconifying panels

   (iconified-p :initform nil :type atom :reader iconified-p)

   (iconify-func 
    :initarg :iconify-func 
    :initform nil 
    :type t 
    :accessor iconify-func)

   (deiconify-func 
    :initarg :deiconify-func 
    :initform nil 
    :type t 
    :accessor deiconify-func)))

;;;
;;; 	Make a panel instance
;;;

(defun make-panel (&rest keys)
  (apply #'make-instance 'panel :allow-other-keys t keys))

;;;
;;;	Class event map handles iconify/deiconify

(defhandler iconified ((self panel) &rest args
                       &default :visibility-notify)
  (declare (ignore args))
  (if (viewable-p self)
      (if (slot-value self 'iconified-p)
          (let ((func (deiconify-func self)))
               (setf (slot-value self 'iconified-p) nil)
               (if func
                   (execute 'deiconify-func self))))
      (if (not (slot-value self 'iconified-p))
          (let ((func (iconify-func self)))
               (setf (slot-value self 'iconified-p) t)
               (if func
                   (execute 'iconify-func self))))))

(defhandler active ((self panel) &rest args
                    &default :enter-window)
  (declare (ignore args))
  (push-panel self)
  (enter-form (get-form self)))

(defhandler inactive ((self panel) &rest args
                      &default :leave-window)
  (declare (ignore args))
  (leave-form (get-form self))
  (pop-panel))

(defmethod new-instance ((self panel)
			 &rest keys
			 &key
			 (title "")
			 &allow-other-keys)
  (declare (ignore keys))
  (call-next-method)
  self)


(defmacro run-panel (self &rest args)
  `(call ,self ,@args))

(defmacro open-panel (self &rest args)
  `(call ,self ,@args))

