;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/frame.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/17 20:50:13 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;; frame gadget class
;;;

(defclass frame (callable-po)
  (
   ;;  inherited slots with overridden defaults

   (event-mask :initform '(:exposure))
   (gm :initform 'packed-gm)
   (conform :initform :dont-conform)
   (geom-spec :initform '(:bottom 0))
   (border-width :initform 2)
   (parent :initform nil)
   (status :initform :concealed)))

(defun make-frame (&rest keys)
  (apply #'make-instance 'frame :allow-other-keys t keys))

;;;
;;; frame slot setf methods
;;;

;;;
;;; frame initialization method
;;;

(defmethod new-instance ((self frame)
			 &rest keys
			 &key
			 (dialogs nil)
			 &allow-other-keys)

  (push `(exit-dialog ("picasso" ,@(cons "exit" "dialog"))) dialogs)

  (apply #'call-next-method self :dialogs dialogs keys)

  self)



(defmethod invoke :around ((self frame) &rest arguments &aux cf)
  (declare (ignore arguments))
  (setq cf (current-frame))
  (if (form-p cf) (setq cf (parent cf)))
  (if (frame-p cf) (conceal cf))
  (unless (parent self) (setf (parent self) (current-tool)))
  (call-next-method)
  (push-frame self)
  (expose self)
  (catch self
	 (event-loop :display (current-display))))

(defmethod leave :after ((self frame) &optional (return-value nil) &aux cf)
  (conceal self)
  (pop-frame)
  (setq cf (current-frame))
  (if (form-p cf) (setq cf (parent cf)))
  (if (frame-p cf) (expose cf))
  (throw self return-value))

(defun goto-frame (self &rest args &aux cf)
  (setq cf (current-frame))
  (if (form-p cf) (setq cf (parent cf)))
  (if cf (catch cf (leave cf)))
  (apply #'invoke self args))

(defmacro call-frame (self &rest args)
  `(call ,self ,@args))

(defmacro run-frame (self &rest args)
  `(call ,self ,@args))
