;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: konstan $
;;; $Source: RCS/dialog.cl,v $
;;; $Revision: 1.3 $
;;; $Date: 90/07/27 11:41:30 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;
;;  OVERVIEW
;;
;; a dialog is very much like a form, except that it is run out of the root
;; window rather than as a part of a frame, and that many dialogs can run at
;; once.
;;

;;;
;;;  	Define dialog class
;;;

(defclass dialog (top-level-po callable-po)
  (
   (place :initform t :reader place)
   ;;  Inherited sloted with overridden defaults
   
   (conform :initform :grow-shrink)
   (border-width :initform 6)
   (background :initform "gray75")
   (gm :initform 'packed-gm)))

(defmethod new-instance ((self dialog) 
                         &key
			 (region nil region-p)
			 (location nil location-p)
			 (x-offset nil x-p)
			 (y-offset nil y-p)
			 &allow-other-keys)
  (when (or region-p
	    location-p
	    (and x-p y-p))
	(setf (slot-value self 'place) nil))
  (call-next-method))


;;;
;;; 	Make a dialog instance
;;;

(defun make-dialog (&rest keys)
  (apply #'make-instance 'dialog :allow-other-keys t keys))

;;;
;;;	Dialog event handling and special attach code
;;;

(defhandler ignore ((self dialog) &rest args
                    &default :leave-window)
  (declare (ignore self args)))

(defhandler raise ((self dialog) &rest event
                   &default :enter-window)
  (declare (ignore event))
  (setf (xlib:window-priority (res self)) :top-if)
  (raise self))

(defmethod do-attach ((self dialog))
  (call-next-method)
  (setf (xlib:window-save-under (res self)) :on)
  (setf (xlib:window-priority (res self)) :top-if))

(defmethod invoke :around ((self dialog) &rest arguments)
  (declare (ignore arguments))
  (call-next-method)
  (push-dialog self)
  (when (place self)
	(let ((lp (lexical-parent self)))
	     (unless (top-level-p lp) (setq lp (parent lp)))
	     (unless (top-level-p lp) (setq lp (parent lp)))
	     (unless (top-level-p lp) (setq lp (parent lp)))
	     (move self (+ (server-x-offset lp) 
			   (round (- (width lp) (width self)) 2))
		        (+ (server-y-offset lp) 
			   (round (- (height lp) (height self)) 2)))))
  (warp-mouse self (round (width self) 2) (round (height self) 2))
  (setf (xlib:window-priority (res self)) :top-if)
  (enter-form (get-form self))
  (catch self (dialog-event-loop self)))

(defun dialog-event-loop (self)
  (let ((in-pane t)
	(dialog-res (res self)))
       (xlib:display-finish-output (res (display self)))
       (event-sync 
	:display (display self) 
	:hang t
	:discard-after-process t
	:handler
	#'(lambda (&rest args &key event-window event-key
		     &allow-other-keys)
		  (cond ((and (eq event-key :leave-notify)
			      (null (getf args :child))
			      (eq event-window dialog-res))
			 (setq in-pane nil))
			((and (eq event-key :enter-notify)
			      (null (getf args :child))
			      (eq event-window dialog-res))
			 (setq in-pane t))
;;;			((and (eq event-key :leave-window)
;;;			      (menu-pane-p (find-window event-window)))
;;;			 (apply #'dispatch-event args))
			((member event-key '(:visibility-notify :exposure))
			 (apply #'dispatch-event args))
			(in-pane (apply #'dispatch-event args))
			((member event-key '(:key-press :button-press))
			 (xlib:bell (getf args :display))))
		  nil))))

(defmethod leave :after ((self dialog) &optional (return-value nil))
  (leave-form (get-form self))
  (pop-dialog)
  (throw self return-value))

(defmacro run-dialog (self &rest args)
  `(call ,self ,@args))

(defmacro call-dialog (self &rest args)
  `(call ,self ,@args))

(defmacro open-dialog (self &rest args)
  `(call ,self ,@args))

