;;;
;;; Copyright (c) 1990 Regents of the University of California
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

(defmacro deftool (name arglist &rest params)
  `(def-internal 'tool ',name ',arglist ',params *deftool-clauses*))

(defmacro defframe (name arglist &rest params)
  `(def-internal 'frame ',name ',arglist ',params *defframe-clauses*))

(defmacro defform (name arglist &rest params)
  `(def-internal 'form ',name ',arglist ',params *defform-clauses*))

(defmacro defpanel (name arglist &rest params)
  `(def-internal 'panel ',name ',arglist ',params *defpanel-clauses*))

(defmacro defdialog (name arglist &rest params)
  `(def-internal 'dialog ',name ',arglist ',params *defdialog-clauses*))

(defconstant *deftool-clauses*
  '((psl :single-sexpr package-search-list)
    (setup-code :single-sexpr )
    (init-code :single-sexpr )
    (exit-code :single-sexpr )
    (static-variables :var-list static static-locals)
    (dynamic-variables :var-list dynamic dynamic-locals variables variable)
    (constants :var-list constant constant-variables)
    (region :single-sexpr )
    (x-offset :single-sexpr x)
    (y-offset :single-sexpr y)
    (width :single-sexpr w)
    (height :single-sexpr h)
    (size :single-sexpr area)
    (location :single-sexpr )
    (title :single-sexpr )
    (autoraise :single-sexpr raise)
    (autowarp :single-sexpr deiconify-warp warp)
    (icon :object-eval-sexpr )
    (icon-name :single-sexpr )
    (frames :multiple-sexpr frame)
    (dialogs :multiple-sexpr dialog)
    (panels :multiple-sexpr panel)
    (start-frame-args :single-sexpr sfa)
    (start-frame :single-sexpr start)))

(defconstant *defframe-clauses* 
  '((setup-code :single-sexpr )
    (init-code :single-sexpr )
    (exit-code :single-sexpr )
    (static-variables :var-list static static-locals variable variables)
    (dynamic-variables :var-list dynamic dynamic-locals)
    (constants :var-list constant constant-variables)
    (form-background :single-sexpr background)
    (form-gray :single=sexpr gray)
    (forms :multiple-sexpr form)
    (form-args :multiple-sexpr fa)
    (dialogs :multiple-sexpr dialog)
    (panels :multiple-sexpr panel)
    (form-children :multiple-sexpr children child)
    (form-visit-order :multiple-sexpr visit-order)
    (form-selectable :multiple-sexpr selectable)
    (menu-bar :single-sexpr menu)
    (gm :single-sexpr geometry-manager)))

(defconstant *defpanel-clauses*
  '((setup-code :single-sexpr )
    (init-code :single-sexpr )
    (exit-code :single-sexpr )
    (static-variables :var-list static static-locals)
    (dynamic-variables :var-list dynamic dynamic-locals variable variables)
    (attach-when-possible :single-sexpr attach)
    (constants :var-list constant constant-variables)
    (forms :multiple-sexpr form)
    (form-args :multiple-sexpr fa)
    (dialogs :multiple-sexpr dialog)
    (panels :multiple-sexpr panel)
    (form-children :multiple-sexpr children child)
    (form-visit-order :multiple-sexpr visit-order)
    (form-selectable :multiple-sexpr selectable)
    (form-background :single-sexpr background)
    (form-gray :single=sexpr gray)
    (menu-bar :single-sexpr menu)
    (gm :single-sexpr geometry-manager)
    (buttons :multiple-sexpr button)
    (iconify-func :single-sexpr)
    (deiconify-func :single-sexpr)
    (title :single-sexpr )
    (autoraise :single-sexpr raise)
    (autowarp :single-sexpr warp deiconify-warp)
    (region :single-sexpr )
    (x-offset :single-sexpr x)
    (y-offset :single-sexpr y)
    (width :single-sexpr w)
    (height :single-sexpr h)
    (size :single-sexpr area)
    (location :single-sexpr )))

(defconstant *defdialog-clauses*
  '((setup-code :single-sexpr )
    (init-code :single-sexpr )
    (exit-code :single-sexpr )
    (static-variables :var-list static static-locals)
    (dynamic-variables :var-list dynamic dynamic-locals variable variables)
    (attach-when-possible :single-sexpr attach)
    (constants :var-list constant constant-variables)
    (forms :multiple-sexpr form)
    (form-args :multiple-sexpr fa)
    (form-background :single-sexpr background)
    (form-gray :single=sexpr gray)
    (dialogs :multiple-sexpr dialog)
    (form-children :multiple-sexpr children child)
    (form-visit-order :multiple-sexpr visit-order)
    (form-selectable :multiple-sexpr selectable)
    (gm :single-sexpr geometry-manager)
    (buttons :multiple-sexpr button)
    (autoraise :single-sexpr raise)
    (region :single-sexpr )
    (x-offset :single-sexpr x)
    (y-offset :single-sexpr y)
    (width :single-sexpr w)
    (height :single-sexpr h)
    (size :single-sexpr )
    (location :single-sexpr )))

(defconstant *defform-clauses*
  '((setup-code :single-sexpr )
    (init-code :single-sexpr )
    (exit-code :single-sexpr )
    (static-variables :var-list static static-locals)
    (dynamic-variables :var-list dynamic dynamic-locals variable variables)
    (constants :var-list constant constant-variables)
    (dialogs :multiple-sexpr dialog)
    (background :single-sexpr form-background)
    (panels :multiple-sexpr panel)
    (children :multiple-sexpr child)
    (visit-order :multiple-sexpr)
    (selectable :multiple-sexpr)
    (gm :single-sexpr geometry-manager)))

(defun handle-alist (type list)
  (setq list (mapcar #'(lambda (x) (remove-quote x) x) list))
  (case type
	(:single-sexpr (car list))
        (:multiple-sexpr (if (and (= (length list) 1)
				  (listp list)
				  (listp (car list))
				  (listp (caar list))
				  (atom (caaar list)))
			     (car list)
			     list))
	(:object-eval-sexpr (if (typep (car list) 'pcl::object)
				(car list)
				(eval (car list))))
	(:var-list (if (and (= (length list) 1)
                            (listp (car list))
		            (> (length (car list)) 2))
		       (car list)
		       list))))



(defun def-internal (po-class name arglist params clauses)
  (let ((doc "")
	(make-params nil)
	(ref-params nil)
	(value-params nil)
	(value-result-params nil)
	(value-update-params nil)
	(value-result-update-params nil)
	(param-type 'value)
	(alist (remove-if-not #'consp params)))

	(dolist (arg arglist)
		(case arg
		      (&value (setq param-type 'value))
		      (&val (setq param-type 'value))
		      (&value-result (setq param-type 'value-result))
		      (&val-res (setq param-type 'value-result))
		      (&copy-in (setq param-type 'value-result))
		      (&value-update (setq param-type 'value-update))
		      (&value-result-update (setq param-type 
						  'value-result-update))
		      (&value-update-result (setq param-type 
						  'value-result-update))
		      (&reference (setq param-type 'reference))
		      (&ref (setq param-type 'reference))
		      (otherwise
		       (case param-type
			     (value (push arg value-params))
			     (value-result (push arg value-result-params))
			     (value-update (push arg value-update-params))
			     (value-result-update 
			      (push arg value-result-update-params))
			     (reference (push arg ref-params))))))
       (when ref-params 
	     (push ref-params make-params)
	     (push :ref-params make-params))

       (when value-params 
	     (push value-params make-params)
	     (push :value-params make-params))

       (when value-update-params 
	     (push value-update-params make-params)
	     (push :value-update-params make-params))

       (when value-result-params 
	     (push value-result-params make-params)
	     (push :value-result-params make-params))

       (when value-result-update-params 
	     (push value-result-update-params make-params)
	     (push :value-result-update-params make-params))

       (setq doc (apply #'concatenate 
			(cons 'string  
			      (mapcan #'(lambda (x) (if (stringp x) (list x)))
				      params))))
       (unless (equal doc "")
	       (push doc make-params)
	       (push :doc make-params))

       (dolist (clause clauses)
	       (let ((item (car clause))
		     (type (second clause))
		     (aliases (cddr clause))
		     (tmp nil))
		    (block trythem
			   (dolist (name (cons item aliases))
				   (setq tmp (cdr (assoc name alist)))
				   (when tmp
					 (push (handle-alist type tmp)
					       make-params)
					 (push (colonize item) make-params)
					 (return-from trythem))))))

       (push name make-params)
       (push :po-name make-params)

       (let ((make-func (symbol-function  
                          (read-from-string
                            (concatenate 'string
                                         "make-"
                                         (string po-class))))))
            (register name (apply make-func make-params)))))
