;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: seitz $
;;; $Source: RCS/start-func.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 90/07/27 17:26:18 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

(defun start-picasso ()
  (unless (member "-noinit" (system:command-line-arguments) :test #'string=)
	  (make-display)
	  (or (load "~/.picasso-init" :if-does-not-exist nil)
	      (load "~/.clinit" :if-does-not-exist nil))
	  (in-package 'pt :use '(lisp pcl))
	  (setq tpl:*prompt* "<picasso> ")
	  (do-whatever-initialization)))

(defun do-whatever-initialization ()
  (load-event-maps)
  (add-var 'po (root-window) (root-window))
  #+multiprocessing 
  (unless mp::*all-processes* (mp:start-scheduler))
  (format t "Picasso Initialized")
  (let ((oldh top-level:*history*)) 
       (setq top-level:*history* 0)
       (setq top-level:*history* oldh)))
