;;;
;;; Copyright (c) 1990 Regents of the University of California
;;;

;; change directory
(tpl:alias "cd" (name) "change directory" 
	   (excl:chdir (string-downcase (string name))))

;; Print working directory
(tpl:alias "pwd" () "print working directory" 
  (format *terminal-io* "~A~%" (namestring (excl:current-directory))))

;; change package
(tpl:alias "cp" (name) "change package"
	   (let* ((symname (if (stringp name)
			       (read-from-string name)
			     name))
		  (package (find-package symname)))
	     (cond ((not (null package))
		    (setq name (string-downcase (package-name package)))
		    (in-package symname)
		    (setq tpl:*prompt* (format nil "<~a> " name)))
		   (t
		    (warn "no package named ~s" symname)))))

;; Load the current directories sysdef file
#+pds
(tpl:alias "lsd" ()
  "Load the sysdef file in the current directory"
   (load "sysdef")
   (setq tpl:*prompt* "<pds> ")
   (in-package 'pds))

;; Repeat an operation 100 times and time it
(tpl:alias "t100" (exp)
  (time (dotimes (i 100)
                 (eval exp))))

;; parse system alias
#+pds
(tpl:alias "ps" (&optional (system ""))
  "Parse a system"
  (if (symbolp system)
      (setq system (string system)))
  (let ((current-package *package*))
       (in-package 'pds)
       (block ls
              (when (equal system "")
                    (format *terminal-io* "System to parse? ")
                    (setq system (read-line *terminal-io*)))
              (when (equal system "")
                    (format *terminal-io* "No system parsed~%")
                    (return-from ls))
              (if (stringp system)
                  (setq system (read-from-string system)))
              (pds::parse-system system))
       (in-package (package-name current-package))))

;; load system alias
#+pds
(tpl:alias "ls" (&optional (system ""))
  "Load a system"
  (if (symbolp system)
      (setq system (string system)))
  (let ((current-package *package*))
       (in-package 'pds)
       (block ls
	      (when (equal system "")
		    (format *terminal-io* "System to load? ")
		    (setq system (read-line *terminal-io*)))
	      (when (equal system "")
		    (format *terminal-io* "No system loaded~%")
		    (return-from ls))
	      (if (stringp system)
		  (setq system (read-from-string system)))
	      (pds::load-system system))
       (in-package (package-name current-package))))

;; compile system alias
#+pds
(tpl:alias "cs" (&optional (system ""))
  "Compile a system"
  (if (symbolp system)
      (setq system (string system)))
  (let ((current-package *package*))
       (in-package 'pds)
       (block ls
	      (when (equal system "")
		    (format *terminal-io* "System to compile? ")
		    (setq system (read-line *terminal-io*)))
	      (when (equal system "")
		    (format *terminal-io* "No system compiled~%")
		    (return-from ls))
	      (if (stringp system)
		  (setq system (read-from-string system)))
	      (pds::compile-system system))
       (in-package (package-name current-package))))

(setq 
  top-level:*zoom-print-level* 5
  top-level:*zoom-print-length* 5
  top-level:*zoom-display* 10)

;; Event loop
#+picasso
(tpl:alias "el" ()
    "A Picasso event loop"
       (pt::event-loop))

#+picasso
(tpl:alias "ea" ()
  "Expose and attach last object"
  (pt::expose (pt::attach *)))

#+picasso
(tpl:alias "da" ()
  "Destroy all windows who are children of the root"
  (when (pt::current-display)
	(let ((rw (pt::root-window)))
	     (when (and rw (pt::res rw))
		   (mapc #'(lambda (x) (pt::conceal x) (pt::destroy x))
			 (pt::children rw))))))

#+picasso
(tpl:alias "ce" ()
  "Clear Picasso Environment"
  (pt::clear-env))

;; load tmp
(tpl:alias "lt" ()
  "Load file named .tmp from home dir"
  (load "~/.tmp"))

;; compile tmp
(tpl:alias "ct" ()
  "Compile file named .tmp from home dir"
  (compile-file "~/.tmp"))

#+gsgc
;; gsgc setup
(progn
  ;; set gsgc switches
  (setf (sys:gsgc-switch :print) t)
  (setf (sys:gsgc-switch :stats) t)
  ;; make alias for :gc
  (tpl:alias "gc" (&rest args) "garbage collection"
	     (cond ((null args) (excl:gc))
		   ((eq :step (car args))
		    (sys:gsgc-step-generation)
		    (excl:gc))
		   ((eq :tenure (car args))
		    (excl:gc :tenure))
		   ((eq :t (car args))
		    (excl:gc t))
		   ((eq :show (car args))
		    (sys:gsgc-parameters))
		   ((eq :spread (car args))
		    (setf (sys:gsgc-parameter :generation-spread)
			  (cadr args)))
		   ((eq :auto (car args))
		    (setf (sys:gsgc-switch :auto-step)
			  (not (sys:gsgc-switch :auto-step))))
		   ((eq :room (car args))
		    (room t))
		   ((eq :print (car args))
		    (setf (sys:gsgc-switch :print)
			  (not (sys:gsgc-switch :print))))
		   (t
		    (format t ":gc [:step] [:tenure] [:show] [:auto] ")
		    (format t "[:spread <arg>] [:room] [:print]~%")))))
#+excl
(setq top-level:*history* 100)

;(defconstant *orig-error* #'error)
;(defconstant *orig-cerror* #'cerror) 

#+picasso
#|(defun error (&rest args &aux disp rw)
  (when (setq disp (pt::current-display))
        (setq disp (pt::res disp))
        (setq rw (pt::root-window)) 
        (when (and rw (pt::attached-p rw))
              (xlib:set-input-focus disp :pointer-root :pointer-root))
        (xlib:ungrab-server disp)
        (xlib:ungrab-pointer disp)
        (xlib:display-force-output disp))
  (apply *orig-error* args))|#

#+picasso
#|(defun cerror (&rest args &aux disp rw)
  (when (setq disp (pt::current-display))
        (setq disp (pt::res disp))
        (setq rw (pt::root-window)) 
        (when (and rw (pt::attached-p rw))
              (xlib:set-input-focus disp :pointer-root :pointer-root))
        (xlib:ungrab-server disp)
        (xlib:ungrab-pointer disp)
        (xlib:display-force-output disp))
  (apply *orig-cerror* args))|#

#+picasso
(tpl:alias "lw" ()
  "Return the window on which the mouse is pressed"
  (pt::locate-window))

#+(and picasso test)
(tpl:alias "steve" ()
  "Load seitz's .tmp.cl file"
  (load "~seitz/.tmp.cl"))

#+(and picasso test)
(tpl:alias "joe" ()
  "Load konstan's .tmp.cl file"
  (load "~konstan/.tmp.cl"))

#+(and picasso test)
(tpl:alias "brian" ()
  "Load bsmith's .tmp.cl file"
  (load "~bsmith/.tmp.cl"))

#+(and picasso test)
(tpl:alias "fix" ()
  (load "~picasso/test/src/sys/fixes/fixup"))

(in-package 'pt)

#+picasso
(defun fmtool ()
  (run-tool-named '("fmtool" "tool")))

#+picasso
(defun test ()
  (run-tool-named '("test" "tool")))

#+picasso
(defun paper ()
  (run-tool-named '("paper" "demo" . "tool")))

#+picasso
(defun tool-editor ()
  (run-tool-named '("ft" "tool")))
