;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/radio-group.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/17 20:42:01 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

(defclass radio-group (button-group)
  ((name :initform "A Radio-Button Group") 
   (value :initform 0)
   (active-image 
    :initform (make-image :name "radio-select" :file "radio-selected.bitmap"))
   (inactive-image 
    :initform (make-image :name "radio-deselect" :file "radio-normal.bitmap"))))

(defmethod (setf value) (val (self radio-group) &aux oldval im)
  (setq oldval (slot-value self 'value))
  (when (and (not (eq val oldval)) 
	     (<= 0 val (length (label-table self)))) 
	(let ((image-table (slot-value self 'image-table))
	      (active-image (slot-value self 'active-image))
	      (inactive-image (slot-value self 'inactive-image)))
	     (setf (slot-value self 'value) val)
	     (setq im (svref image-table oldval))
	     (rplaca im inactive-image) 
	     (clear-region self (getf (cdr im) :x)  (getf (cdr im) :y) 
			   (getf (cdr im) :width) (getf (cdr im) :height)) 
	     (apply #'put im)
	     (setq im (svref image-table val))
	     (rplaca im active-image)
	     (clear-region self (getf (cdr im) :x) (getf (cdr im) :y) 
			   (getf (cdr im) :width) (getf (cdr im) :height)) 
	     (apply #'put im))
	val))

(defmethod update-value ((self radio-group) &aux val)
  (setq val (slot-value self 'value))
  (let ((image-table (slot-value self 'image-table))
	(active-image (slot-value self 'active-image)))
       (rplaca (svref image-table val) active-image)
       (repaint self))
  val)

(defun make-radio-group (&rest keys)
  (apply #'make-instance 'radio-group :allow-other-keys t keys))

(defun make-radio-button-group (&rest keys)
  (apply #'make-instance 'radio-group :allow-other-keys t keys))

(defhandler select ((self radio-group) &key x y &allow-other-keys 
		    &aux image-table active-image inactive-image index val
		    &default :button-press)
  (setq image-table (slot-value self 'image-table)
	active-image (slot-value self 'active-image)
	inactive-image (slot-value self 'inactive-image)
	val (slot-value self 'value))
  
  ;;	find which pair was clicked, if any
  (if (not (eq (orientation self) :vertical)) 
      (let* ((im (cdr (svref image-table 0)))
	     (w (getf im :width))
	     (h (getf im :height)))
	    (when (> y h) (return-from radio-group-select))
	    (setq index (truncate x w))
	    (when (eq val index) (return-from radio-group-select)))
      (let* ((im (cdr (svref image-table 0)))
	     (w (getf im :width))
	     (h (getf im :height)))
	    (when (> x w) (return-from radio-group-select))
	    (setq index (truncate y h))
	    (when (eq val index) (return-from radio-group-select))))
  
  ;;	set value appropriately
  (setf (value self) index))
