;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/check-group.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 90/07/22 12:26:12 $
;;;

(in-package 'pt :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;;  A check-group is a type of button group used to implement check boxes.
;;;  See the documentation on button-group for details.
;;;

(defclass check-group (button-group)
  ((name :initform "Check-Box Group") 
   (active-image 
    :initform (make-image :name "check-select" :file "check-true.bitmap"))
   (inactive-image 
    :initform (make-image :name "check-deselect" :file "check-false.bitmap"))))

(defun make-check-group (&rest keys)
  (apply #'make-instance 'check-group :allow-other-keys t keys))
