;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/swap-button.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/17 20:39:19 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;; This file contains code for the swap button, a button that displays
;;; the swap.bitmap file.  This image looks like this:
;;;
;;;			                **
;;;		          **********    **
;;;		        **          **  **
;;;		      **              ****
;;;		    **          **********
;;;		    **
;;;		    **
;;;			                **
;;;			                **
;;;		    **********          **
;;;		    ****              **
;;;		    **  **          **
;;;		    **    **********
;;;		    **
;;;

(defun make-swap-button (&rest keys)
  (setf (getf keys :value) (make-image :name "swap" :file "swap-bitmap"))
  (apply #'make-gray-button keys))
