;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/click-button.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/17 20:38:47 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;; click-button class
;;;

(defclass click-button (button)
  ((name :initform "A Click Button")

   (data :initform nil :type t :accessor data)
   (left-func 
    :initarg :left-func  
    :initform nil 
    :type t 
    :accessor left-func)
   (middle-func 
    :initarg :middle-func  
    :initform nil 
    :type t 
    :accessor middle-func)
   (right-func 
    :initarg :right-func  
    :initform nil 
    :type t 
    :accessor right-func)))

(defun make-click-button (&rest keys)
  (apply #'make-instance 'click-button :allow-other-keys t keys))

;;
;;	Determine whether or not an object is a click-button
;;

(defmacro click-button-p (self)
  `(typep ,self 'click-button))

;;;
;;;	Accessor methods
;;;

(defmethod func ((self click-button))
  (left-func self))

(defmethod (setf func) (value (self click-button))
  (setf (left-func self) value))

;;;
;;; Button event handlers
;;;

(defhandler select-1 ((self click-button) &rest args &aux pause
		      &default (:button-press :detail :left-button))
  (declare (ignore args))
  (setf (pushed self) :left
	(flag self) nil)
  (when (dimmed self)
	(return-from click-button-select-1))
  (setf (inverted self) t)
  (setq pause (pause-seconds self)))

(defhandler select-2 ((self click-button) &rest args &aux pause
		      &default (:button-press :detail :middle-button))
  (declare (ignore args))
  (setf (pushed self) :middle
	(flag self) nil)
  (when (dimmed self)
	(return-from click-button-select-2))
  (setf (inverted self) t)
  (setq pause (pause-seconds self)))

(defhandler select-3 ((self click-button) &rest args &aux pause
		      &default (:button-press :detail :right-button))
  (declare (ignore args))
  (setf (pushed self) :right
	(flag self) nil)
  (when (dimmed self)
	(return-from click-button-select-3))
  (setf (inverted self) t)
  (setq pause (pause-seconds self)))

(defhandler deselect ((self click-button) &rest args &aux pu 
		      &default :button-release)
  (when (dimmed self)
	(return-from click-button-deselect))
  ;; 	Pause for specified time
  (when (numberp (pause-seconds self))
	(sleep (pause-seconds self)))
  ;;	Un-invert the area enclosed within the border if pushed
  (when (pushed self)
	(setf (inverted self) nil))
  ;;	Call apropriate release func
  (when (setq pu (pushed self))
	(cond ((eq pu :left)
	       (execute 'left-func self args))
	      ((eq pu :middle)
	       (execute 'middle-func self args))
	      ((eq pu :right)
	       (execute 'right-func self args))))

  (setf (pushed self) nil
	(flag self) t))

(defhandler leave ((self click-button) &rest args
		   &default :leave-window)
  (declare (ignore args))
  (when (pushed self)
	(setf (flag self) (pushed self))
	(setf (pushed self) nil)
	(setf (inverted self) nil)))

(defhandler enter ((self click-button) &rest args &aux f 
		   &default :enter-window)
  ;;	If click-button was pushed, left and reentered
  (setq f (flag self))
  (cond ((eq f :left)
	 (apply #'click-button-select-1 (cons self args)))
	((eq f :middle)
	 (apply #'click-button-select-2 (cons self args)))
	((eq f :right)
	 (apply #'click-button-select-3 (cons self args)))))

