;;;
;;; Shared Object Hierarchy
;;;
;;; Copyright (c) 1986 Regents of the University of California
;;; 
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 
;;; $Author: picasso $
;;; $Source: RCS/fn-cache.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/18 13:13:31 $
;;;

(in-package 'pcl :use '(lisp libpq))

;;;
;;;	Cache for compiled functions.
;;;

(defvar fn-cache-by-name (make-hash-table))
(defvar fn-cache-by-value (make-hash-table))

(defun fn-reset-cache () 
  (clrhash fn-cache-by-name)
  (clrhash fn-cache-by-value))

(defun fn-fetch-instance (afn-name)
  (let ((afn-instance (gethash afn-name fn-cache-by-name :failure)))
    (if (eq afn-instance :failure)
	(warn "fn-fetch-instance: no function named ~s" afn-name))
    afn-instance))

(defun fn-fetch-name (afn-instance)
  (let ((afn-name (gethash afn-instance fn-cache-by-value :failure)))
    (if (eq afn-name :failure)
	(warn "fn-fetch-name: no named function for instance ~s" afn-instance))
    afn-name))

(defun fn-append (afn-name afn-instance)
  (let ((afn-name2 )
	(afn-instance2 ))
    (if (not (eq (gethash afn-name fn-cache-by-name :failure) :failure))
	(warn "fn-append: function name already bound"))
    (if (not (eq (gethash afn-instance fn-cache-by-value :failure) :failure))
	(warn "fn-append: function instance already bound"))
    (setf (gethash afn-name fn-cache-by-name) afn-instance)
    (setf (gethash afn-instance fn-cache-by-value) afn-name)))

;;;
;;; exports
;;;
(export '(fn-fetch-instance
	  fn-fetch-name
	  fn-append
	  fn-reset-cache)
	(find-package 'pcl))







