;;;
;;; Shared Object Hierarchy
;;;
;;; Copyright (c) 1986 Regents of the University of California
;;; 
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 
;;; $Author: picasso $
;;; $Source: RCS/exit.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/18 13:13:25 $
;;;

(in-package 'pcl :use '(lisp))

(defun save-cache ()
  (maphash #'(lambda (key val)
	       (declare (ignore key))
	       (when (not (equal (cadddr val) 'local-copy))
		     (store-dbobject (car val)) (write-line "object stored") (terpri)))
	   *dbobject-cache*))




