;;;
;;; Shared Object Hierarchy
;;;
;;; Copyright (c) 1986 Regents of the University of California
;;; 
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 
;;; $Author: picasso $
;;; $Source: RCS/defdbclass.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/18 13:13:24 $
;;;

(in-package 'pcl :use '(lisp))

;;;
;;; Define a meta-class "objid-meta-class" which have special behavior with
;;; slot accessing.
;;; We assume user-defined dbclasses do not have slots named %id.
;;; An objid is a list '(relid oid) where
;;; relid is the POSTGRES oid for the class, and oid is the POSTGRES oid for
;;; the object.
;;;

(defclass objid-meta-class (class) () (:metaclass class))

(define-meta-class objid-meta-class (lambda (x) (class-of--class x)))

(defmeth check-super-metaclass-compatibility ((class objid-meta-class) (super class))
  (declare (ignore class super))
  t)

(defmeth check-super-metaclass-compatibility ((class class) (super objid-meta-class))
  (declare (ignore class super))
  t)

(defclass objid () 
  ((%id :initform nil :type CONS))
  (:metaclass objid-meta-class))

;;;
;;; Define a meta-class "dbclass" which is the set of persistent classes
;;;
(defclass dbclass (class) () (:metaclass class))

(define-meta-class dbclass (lambda (x) (class-of--class x)))

(defmeth check-super-metaclass-compatibility ((class dbclass) (super class))
  (declare (ignore class super))
  t)

(defmeth check-super-metaclass-compatibility ((class class) (super dbclass))
  (declare (ignore class super))
  t)

;;;
;;; Dbobject should be inherited by all persistent classes
;;; The slot halloween is a hack to get around the Halloween problem
;;; when updating an object stored in the POSTGRES database.
;;;
(defclass dbobject (object) 
  ((objid :initform nil :type OBJID)
   (halloween :initform 0 :type INTEGER))
  (:metaclass dbclass))


;;; HACK for class-of
;;;

;(defvar *class-of-hack-loaded* nil)

;(eval-when (compile load eval)
;	   (when (null *class-of-hack-loaded*)
;		 (setf (symbol-function '%class-of)
;		       (symbol-function 'class-of))
;		 (unintern 'class-of)
;		 (setq *class-of-hack-loaded* t)))
;
;(setf (symbol-function '%class-of)
;      (symbol-function 'class-of))
;
;(unintern 'class-of)
;		 
;(defmethod class-of (self)
;  (%class-of self))
;
;(defmethod class-of ((self objid))
;  (%class-of (get-dbobject self)))

;;;
;;; exports
;;; 
;;; I am having trouble with packages.  That is why halloween and %id are
;;; exported.
;;;

(export '(dbclass
	  dbobject
	  halloween
	  %id
	  objid)
	(find-package 'pcl))
