;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/text.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/17 20:33:24 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;; Method to return the width a string in pixels
;;;
(defmethod width ((string string) &key (font nil) (gc nil) (start 0) (end nil))
  (text-width string :font font :gc gc :start start :end end))

;;;
;;; 	Function to return the width of a string in pixels
;;;
(defun text-width (string &key (font nil) (gc nil) (start 0) (end nil))
  ;; Make sure font is a font object
  (cond ((null font)
	 (if (xlib:gcontext-p gc) 
	     (setq font (xlib:gcontext-font gc))))
	((font-p font)
	 (setq font (res font)))
	((stringp font)
	 (setq font (get-font font))
	 (if (font-p font) 
	     (setq font (res font)))))
  ;; Test validity of font
  (if (xlib:font-p font)
      (if (integerp end) 
	  (xlib:text-width font string :start start :end end) 
	  (xlib:text-width font string :start start))
      0))

;;;
;;; Return the width of a character
;;;
(defmethod width ((character character)
		  &key
		  (font nil))
  (if (not (font-p font))
      (error "character.width: invalid font ~s" font))
  ;; test character argument
  (if (characterp character)
      ;; return the width of this character
      (xlib:text-width (res font) (string character))
    ;; signal error
    (error "character.width: invalid character argument ~s" character)))

;;;
;;; Return the bitmap of a character
;;;
#|(defmethod bitmap ((character character)
		   &key
		   (font nil))
  (if (not (font-p font))
      (error "character.bitmap: invalid font ~s" font))
  ;; test character argument
  (if (characterp character)
      ;; return a bitmap
      (make-bitmap
	:id (xcl:x-char-bitmap (id font) (char-code character))
	:width (width character :font font)
	:height (height font))
    ;; signal error
    (error "character.bitmap: invalid character argument ~s" character)))|#

;;;
;;; Put text in a window
;;;
(defmethod put ((self string)
		&key
		(window 	nil)
		(gc 		nil)
		(font 		nil)
		(x 		0)
		(y 		0)
		(height 	nil)
		(width 		nil)
		(start 		0)
		(end 		nil)
		(mask 		0)
		(dimmed 	nil)
		(gray 		nil)
		(inverted 	nil)
		(gc-invert 	nil)
		(gc-dimmed 	nil)
		(ignore-bounds	nil)
		(horiz-just 	:center)
		(vert-just 	:center)
		&allow-other-keys)
  
  ;; test window
  (unless window
	  (warn "string.put: invalid window \`~s\`." window))
  
  (if (and (integerp mask) (zerop mask))
      (setq mask (color-display-p (display window))))

  ;; get gc
  (if (and inverted gc-invert)
      (setq gc gc-invert))
  (unless (or gc (setq gc (gc-res window)))
	  (warn "string.put: invalid gc \`~s\`." gc))
  (if font
      (setf (xlib:gcontext-font gc)
	    (if (xlib:font-p font)
		font
		(res font))))
  
  (when dimmed 
	(setq gray dimmed)
	(unless gc-dimmed (setq gc-dimmed gc)))

  (when (and (color-display-p) gray)
	(setq gray nil
	      gc gc-dimmed))
  
  ;; adjust x, y according to justification requirements.
  (let ((win-width (if width width (slot-value window 'width)))
	(win-height (if height height (slot-value window 'height)))
	(res (res window))
	(sw (text-width self :gc gc))
	(sh (font-ascent nil gc))
	(tfh (font-height nil gc)))
       (incf y 
	     (case vert-just 
		   (:top sh)
		   (:bottom (max 0 (- win-height sh) (font-ascent nil gc)))
		   (t (let ((i (+ (round (/ (- win-height (font-height nil gc)) 
					  2)) 
				(font-ascent nil gc))))
			   (if ignore-bounds
			       i
			       (max 0 i))))))
       (case horiz-just
	     (:left nil)
	     (:right (incf x (max 0 (- win-width sw))))
	     (t 
	      (incf x 
		    (let ((i (round (/ (- win-width sw) 2))))
			 (if ignore-bounds
			     i
			     (max 0 i))))))
       
       ;; draw text
       (if (color-display-p (display window))
	   (if mask
	       (xlib:draw-glyphs res gc x y self :width width
				 :start start :end end)
	       (xlib:draw-image-glyphs res gc x y self :width width
				       :start start :end end))
	   (if mask
	       (if gray
		   (progn
		    (xlib:draw-rectangle res gc-dimmed x (- y sh) sw tfh t)
		    (if (integerp end) 
			(xlib:draw-glyphs res gc x y self 
					  :width width :start start :end end) 
			(xlib:draw-glyphs res gc x y self 
					  :width width :start start))
		    (xlib:draw-rectangle res gc-dimmed x (- y sh) sw tfh t))
		   (if (integerp end) 
		       (xlib:draw-glyphs res gc x y self 
					 :width width :start start :end end) 
		       (xlib:draw-glyphs res gc x y self 
					 :width width :start start)))
	       (if gray
		   (progn
		    (xlib:draw-rectangle res gc-dimmed x (- y sh) sw tfh t)
		    (xlib:draw-glyphs res gc x y self 
				      :width width :start start :end end) 
		    (xlib:draw-rectangle res gc-dimmed x (- y sh) sw tfh t))
		   (if (integerp end) 
		       (xlib:draw-image-glyphs res gc x y self 
					       :width width :start start :end end) 
		       (xlib:draw-image-glyphs res gc x y self 
					       :width width :start start)))))))

(defmethod put ((self list)
		&key
		(window nil)
		(gc nil)
		(font nil)
		(x 0)
		(y 0)
		(height nil)
		(width nil)
		(mask nil)
		(gray nil)
		(horiz-just :center)
		(vert-just :center)
		&allow-other-keys)
  
  (unless (stringp (car self)) (return-from put))
  ;; test window
  (unless window
	  (warn "string.put: invalid window \`~s\`." window))
  ;; get gc
  (unless (or gc (setq gc (gc-res window)))
	  (warn "string.put: invalid gc \`~s\`." gc))
  
  (if font
      (setf (xlib:gcontext-font gc)
	    (if (xlib:font-p font)
		font
		(res font))))
  (unless height (setq height (height window)))
  (unless width (setq width (width window)))
  (let* ((fh (font-height nil gc)) 
	 (fa (font-ascent nil gc))
	 (len (length self))
	 (top-offset 
	  (case vert-just
		(:top fa)
		(:center (+ fa (round (/ (- height (* fh len)) 2))))
		(:bottom (- height (* fh len) (- fa)))))
	 (widths (mapcar #'(lambda (x) (text-width x :gc gc)) self))
	 (rx 0)
	 (ry 0))
	(do* ((str-list self (cdr str-list))
	      (str (car str-list) (car str-list))
	      (sw-list widths (cdr sw-list))
	      (sw (car sw-list) (car sw-list))
	      (count 0 (1+ count)))
	     ((null str-list))
	     (setq ry (+ top-offset (* fh count)))
	     (case horiz-just
		   (:left (setq rx 0))
		   (:right (setq rx (- width sw)))
		   (:center (setq rx (round (/ (- width sw) 2)))))
	     (setq rx (+ rx x))
	     (setq ry (+ ry y))
	     
	     ;; put text in specified color(s)
	     (if gray
		 (if mask 
		     (draw-gray-text-mask (res window) gc str rx ry sw fh)
		     (draw-gray-text (res window) gc str rx ry sw fh))
		 (if mask
		     (xlib:draw-glyphs (res window) gc rx ry str)
		     (xlib:draw-image-glyphs (res window) gc rx ry str))))))
