;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/screen.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 90/07/22 14:16:55 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;; screen class
;;;

(defclass screen ()
  ((number
    :initarg :number 
    :initform 0
    :type integer
    :reader number)
   (res
    :initarg :res 
    :initform nil
    :type vector
    :reader res)
   (display
    :initarg :display 
    :initform nil
    :type display
    :reader display)
   (root
    :initarg :root 
    :initform nil
    :type root-window
    :reader root)
   (colormap-table
    :initform nil
    :type hash-table
    :reader colormap-table)))

(defun make-screen (&rest keys)
  (apply #'make-instance 'screen :allow-other-keys t keys))

(defun get-colormap (&optional name spec)
  (cond ((screen-p spec) 
	 (if name 
	     (gethash name (colormap-table spec))
	     (current-colormap spec)))
	((display-p spec)
	 (if name 
	     (gethash name (colormap-table (current-screen 
					    (default-colormap spec))))
	     (current-colormap spec)))
	((window-p spec)
	 (if name 
	     (gethash name (colormap-table (screen spec)))
	     (current-colormap spec)))
	(spec
	 (error "get-color: illegal second argument \'~s\'" spec))
	(t (gethash name (colormap-table (current-screen))))))

(defun init-display-screens (display &aux screen table)
  "Return the first screen"

  ;; create screen-table
  (setf (slot-value display 'screen-table)
	(setq table (make-array (list (xlib:display-nscreens (res display))))))

  ;; create screens
  (do* ((screens (xlib:display-roots (res display)) (cdr screens))
	(res (car screens))
	(num 0 (1+ num)))
       ((null screens))
       ;; create screen
       (setq screen (make-screen :number num :res res :display display))
       (setf (aref table num) screen))
  
  ;; return first screen
  (aref table 0))

(defun init-screen-colors (&optional (self (colormap (root-window))))
  ;; make white/black color
  (make-color :name "white" :colormap self :attach-p t)
  (make-color :name "black" :colormap self :attach-p t)
  (when (color-display-p self)
	(make-color :red .50 :green .50 :blue .50 :colormap self
		    :name "gray25" :attach-p t)
	(make-color :red .60 :green .60 :blue .60 :colormap self
		    :name "gray50" :attach-p t)
	(make-color :red .80 :green .80 :blue .80 :colormap self
		    :name "gray75" :attach-p t)))

(defmethod new-instance ((self screen)
			 &rest args)
  (declare (ignore args))
  (call-next-method)
  (setf (slot-value self 'root)
	(make-root-window :screen self :display (display self)))
  (init-screen-colors (colormap (root self)))
  self)

(defmethod do-detach ((self screen))
  (dolist (ch (children (root self)))
	  (detach ch))
  (setf (slot-value self 'res) nil))
