;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/paint.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 90/07/22 14:16:53 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;;	get-paint takes a name as an argument and returns the associated
;;;	color or image.  If only a color exists with the given name,
;;;	find-paint returns the color.  If only an image exists, find-paint
;;;	returns the image.  If both exist, find-paint checks the display to
;;;	see if it's color or not.  If the display is color, find-paint 
;;;	returns the color, otherwise, the image is returned.
;;;	This functions is especially useful in choosing backgrounds and
;;;	foregrounds.
;;;

(defun get-paint (&optional name (spec (current-display)) 
		       &aux display colormap color image)

  ;; find colormap
  (cond ((window-p spec)
	 (setq display (display spec))
	 (setq colormap (default-colormap display)))
	((display-p spec)
	 (setq display spec)
	 (setq colormap (default-colormap display)))
	((display-p spec)
	 (setq colormap spec))
	(t
	 (error "get-paint: illegal argument ~s" spec)))

  ;; retrieve specifed color and image (if any)
  (setq color (get-color name colormap)
	image (get-image name))

  ;; return appropriate one
  (cond ((and color image)
	 (if (black-and-white-display-p display)
	     image
	     color))
	(color color)
	(t image)))

;;;
;;; Put method on colors
;;;
(defmethod put ((self color)
		&key
		(window 	(root-window))
		(gc 		nil)
		(x 		0)
		(y 		0)
		(x-offset 	0)
		(y-offset 	0)
		(width 		8)
		(height 	8)
		(pix-width 	0 widthp)
		(pix-height 	0 heightp)
		(horiz-just 	:center)
		(vert-just 	:center)
		&allow-other-keys &aux res)
  ;; test width specified
  (when (null widthp)
	(setq pix-width width))
  (when (null heightp)
	(setq pix-height height))
  (unless gc (setq gc (gc-res window)))
  ;; adjust x and y according to justification requirements
  (let ((w (if width (+ width x) (slot-value window 'width)))
	(h (if height (+ height y) (slot-value window 'height))))
       (cond ((eql vert-just :bottom)
	      (setq y (- h pix-height)))
	     ((eql vert-just :center)
	      (incf y (round (/ (- h y pix-height) 2)))))
       (cond ((eql horiz-just :right)
	      (setq x (- w pix-width)))
	     ((eql horiz-just :center)
	      (incf x (round (/ (- w x pix-width) 2))))))
  ;; put image
  (let ((curr-fg (xlib:gcontext-foreground gc)))
       (setf (xlib:gcontext-foreground gc) (pixel self))
       (xlib:draw-rectangle (res window) gc x y pix-width pix-height t)
       (setf (xlib:gcontext-foreground gc) curr-fg))
  ;; return image
  self)
