;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/icon.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/17 20:33:00 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;; icon class
;;;

(defclass icon (tile)
  ((name :initform "An Icon")
   (value :initarg :value  :initform "An Icon" :type t :accessor value)))

(defun make-icon (&rest keys)
  (apply #'make-instance 'icon :allow-other-keys t keys))

(defmacro icon-p (self)
  "determine if this object is an icon"
  `(typep ,self 'icon))

(defmethod do-attach ((self icon))
  (setf (slot-value self 'window) (root-window))
  (call-next-method))
