;;;
;;; Copyright (c) 1990 Regents of the University of California
;;;
;;; $Author: picasso $
;;; $Source: RCS/gif-utils.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/22 14:17:29 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

(defconstant *gif-id* "GIF87a")
(defvar *load-gif-loaded* nil)

(unless *load-gif-loaded*
	(load "load-gif.o")
	(setq *load-gif-loaded* t))

(ff:DEFFOREIGN 'LOAD-GIF
  :ENTRY-POINT "_load_gif"
  :return-type :integer
  :ARGUMENTS t)

(defun probe-gif (filename
		 &aux 
		 width height   ; of gif raster.
		 )
  (let ((stream 
	 (open filename
	       :direction :input
	       ;; :element-type t
	       :if-does-not-exist nil)
	 ))
    ;; verify file header
    (if (null stream) (return-from probe-gif nil))
    (when (not (string= (readn stream 6)
			*gif-id*))
	  (error "not a GIF file.")
	  )

    ;; get picture size.
    (setq width (read-int stream))
    (setq height (read-int stream))
    (close stream)
    (values width height)
    ))

(defun read-int (stream)
  (+ (char-code (read-char stream))
     (* 256 (char-code (read-char stream)))))

(defun readn (stream n &aux (str ""))
  (dotimes (ignored n)
	   (setq str (concatenate 'string
				  str (string (read-char stream)))))
  str)

;; ce is 0 to 255.  sd is number of significant digits.
;; converts into a float from 0 to 1.0 of sd signf. digits. 
(defun convert-color-element (ce sd &aux e)
  (setf e (expt 10 sd))
  (float (/ (truncate (* e (/ ce 255))) e)))

;;
;; allocate colors necessary to display the image in data.
;; return the number of bits that had to be stripped or nil if
;; color allocation failed.
;; modify data to reflect the pixels values returned by X.
;;
(defun allocate-colors (colormap red green blue used num-colors)
  (let ((pixel-table (make-array '(256) :element-type 'xlib:pixel))
	(sd 3)				;significant digits for colors.
	color)
    (dotimes (i num-colors t)
	     (when (not (= (aref used i) 0))
		   (setq color
			 (xlib:make-color
			  :red (convert-color-element (aref red i) sd)
			  :green (convert-color-element (aref green i) sd)
			  :blue (convert-color-element (aref blue i) sd)))
		   (setf (aref pixel-table i)
			 (xlib:alloc-color colormap color))
		   ))
    pixel-table))

(defun fix-pixel-values (data pt)
  (dotimes (i (length data))
	   (setf (aref data i)
		 (aref pt (aref data i))))
  data)

#|
(multiple-value-setq (w h)
		     (probe-gif "moonflag.gif"))

(setq data (make-array (list (* w h)) :element-type 'xlib::card8))
(setq a (make-array '(256) :element-type 'xlib::card8))
(setq b (make-array '(256) :element-type 'xlib::card8))
(setq c (make-array '(256) :element-type 'xlib::card8))
(setq u (make-array '(256) :element-type 'xlib::card8))

(setq num-colors (load-gif "moonflag.gif" data a b c u))

(setq cw (make-collection-widget :parent (root-window)
				 :base-size '(320 200)))
(attach cw)
(setq colormap (xlib:window-colormap (res cw)))

;;(xlib:create-colormap :direct-color (res cw))
(setq gc (make-gc cw nil))

(setq pt (allocate-colors colormap a b c u num-colors))
(fix-pixel-values data pt)
	     
(setf image 
      (xlib:create-image :bits-per-pixel 8
			 :bytes-per-line 320
			 :data data
			 :height 200
			 :width 320
			 :format :z-pixmap
			 :depth 8))

(XLIB:PUT-IMAGE (RES CW) GC IMAGE :X 0 :Y 0 :WIDTH 320 :HEIGHT 200)
(flush-display)
|#
