;;;
;;; Copyright (c) 1990 Regents of the University of California
;;;
;;; $Author: picasso $
;;; $Source: RCS/display-text.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/17 20:32:37 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

(defclass dtext ()
  ((value :initform nil :type t :accessor value :initarg value) 
   (font :initform nil :type t :accessor font :initarg font)
   (paint :initform nil :type t :accessor paint :initarg paint)
   (gc :initform nil :type t)
   (horiz-just :initform :center :type t :accessor horiz-just 
	       :initarg horiz-just)
   (vert-just :initform :center :type t :accessor vert-just 
	      :initarg vert-just)))

(defun make-dtext (&rest args)
  (apply #'make-instance 'dtext :allow-other-keys t args))

(defmethod put ((self dtext)
		&key
		(window 	nil)
		(gc 		nil)
		(font 		nil)
		(x 		0)
		(y 		0)
		(height 	nil)
		(width 		nil)
		(start 		0)
		(end 		nil)
		(mask 		0)
		(dimmed 	nil)
		(gray 		nil)
		(inverted 	nil)
		(gc-invert 	nil)
		(gc-dimmed 	nil)
		(horiz-just 	:center)
		(vert-just 	:center)
		&allow-other-keys)
  
  (setq font (font self)
	gc (slot-value self 'gc)
	horiz-just (horiz-just self)
	vert-just (vert-just self))
  (setq self (value self))

  ;; test window
  (unless window
	  (warn "string.put: invalid window \`~s\`." window))
  
  (if (and (integerp mask) (zerop mask))
      (setq mask (color-display-p (display window))))

  ;; get gc
  (if (and inverted gc-invert)
      (setq gc gc-invert))
  (unless (or gc (setq gc (gc-res window)))
	  (warn "string.put: invalid gc \`~s\`." gc))
  (if font
      (setf (xlib:gcontext-font gc)
	    (if (xlib:font-p font)
		font
		(res font))))
  
  (when dimmed 
	(setq gray dimmed)
	(unless gc-dimmed (setq gc-dimmed gc)))

  (when (and (color-display-p) gray)
	(setq gray nil
	      gc gc-dimmed))
  
  ;; adjust x, y according to justification requirements.
  (let ((win-width (if width width (slot-value window 'width)))
	(win-height (if height height (slot-value window 'height)))
	(res (res window))
	(sw (text-width self :gc gc))
	(sh (font-ascent nil gc))
	(tfh (font-height nil gc)))
       (cond ((eql vert-just :bottom)
	      (incf y (max 0 (- win-height sh) (font-ascent nil gc))))
	     ((eql vert-just :center)
	      (incf y (max 0 (+ (round (/ (- win-height 
					     (font-height nil gc)) 
					  2)) 
				(font-ascent nil gc))))))
       (cond ((eql horiz-just :right)
	      (incf x (max 0 (- win-width sw))))
	     ((eql horiz-just :center)
	      (incf x (max 0 (round (/ (- win-width sw) 2))))))
       
       ;; draw text
       (if mask
	   (if gray
	       (progn
		(xlib:draw-rectangle res gc-dimmed x (- y sh) sw tfh t)
		(if (integerp end) 
		    (xlib:draw-glyphs res gc x y self 
				      :width width :start start :end end) 
		    (xlib:draw-glyphs res gc x y self 
				      :width width :start start))
		(xlib:draw-rectangle res gc-dimmed x (- y sh) sw tfh t))
	       (if (integerp end) 
		   (xlib:draw-glyphs res gc x y self 
				     :width width :start start :end end) 
		   (xlib:draw-glyphs res gc x y self 
				     :width width :start start)))
	   (if gray
	       (progn
		(xlib:draw-rectangle res gc-dimmed x (- y sh) sw tfh t)
		(xlib:draw-glyphs res gc x y self 
					:width width :start start :end end) 
		(xlib:draw-rectangle res gc-dimmed x (- y sh) sw tfh t))
	       (if (integerp end) 
		   (xlib:draw-image-glyphs res gc x y self 
					   :width width :start start :end end) 
		   (xlib:draw-image-glyphs res gc x y self 
					   :width width :start start))))))
