;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/var-macros.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/17 20:20:34 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

(defmacro lookup (name &optional (place '(lexical-environment)))
  `(find-var ,name ,place))

(defmacro symbolify (list)
  `(read-from-string (coerce ,list 'string)))

(defun value-var-reader (stream subchar arg)
  (list 'value (reference-var-reader stream subchar arg)))

(eval-when (compile load eval)
(set-dispatch-macro-character #\# #\! #'value-var-reader))


(defun reference-var-reader (stream subchar arg)
  (declare (ignore subchar arg))
  (let ((variable (read stream t nil t))
	(lvar nil)
	(vtail nil))
       (cond
	((consp variable) (car variable))
	(t
         (setq lvar (coerce (string variable) 'list))
         (when (eql (car (last lvar)) #\@)
	       (let ((next (read stream t nil t))
		     (after (peek-char nil stream t nil)))
		    (setq lvar (nconc lvar 
				      (coerce (prin1-to-string next) 'list)))
		    (when (eql after #\/)
			  (setq lvar 
				(nconc lvar
				       (coerce (string (read stream t nil t))
					       'list))))))
	 (setq vtail (member #\/ lvar))
	 (let* ((start (butlast lvar (length vtail)))
		(rest (cdr vtail))
		(retval (if  (setq vtail (member #\@ start))
			     `(lookup ',(symbolify 
					 (butlast start (length vtail)))
				      ,(symbolify (cdr vtail)))
			     `(lookup ',(symbolify start)))))
	       (dolist (v (get-vars-from rest))
		       (setq retval `(lookup ',v (value ,retval))))
	       retval)))))

(defun get-vars-from (list &aux tail)
  (if (null list) nil
                  (if (setq tail (member #\/ list))
		      (cons (symbolify (butlast list (length tail)))
			    (get-vars-from (cdr tail)))
		      (list (symbolify list)))))

(eval-when (compile load eval)
  (set-dispatch-macro-character #\# #\? #'reference-var-reader))

(defun setup-read-macros ()
  (set-dispatch-macro-character #\# #\! #'value-var-reader)
  (set-dispatch-macro-character #\# #\? #'reference-var-reader))

(defmacro enforce-constants ()
  `(setq *constants-enforced* t))

(defmacro relax-constants ()
  `(setq *constants-enforced* nil))
