;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: konstan $
;;; $Source: RCS/lexical-stack.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 90/07/23 11:42:16 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

(defvar *current-environment* nil)
(defvar *starting-po-list* nil)
(defvar *current-dialogs* nil)
(defvar *current-panel* nil)
(defvar *current-frames* nil)
(defvar *current-tool* nil)

(defmacro lexical-environment ()
  `*current-environment*)

(defmacro refresh-environment ()
  `(setq *current-environment*
         (or
	  (starting-po)
	  (current-dialog)
	  (current-panel)
	  (current-frame)
	  (current-tool)
	  (root-window))))

(defmacro push-env (place)
  `(prog1 (push ,place *starting-po-list*)
	  (refresh-environment)))

(defmacro pop-env ()
  `(prog1 (pop *starting-po-list*)
	  (refresh-environment)))

(defmacro starting-po ()
  `(car *starting-po-list*))

(defmacro push-dialog (dialog)
  `(prog1 (push (get-form ,dialog) *current-dialogs*)
	  (refresh-environment)))

(defmacro pop-dialog ()
  `(prog1 (pop *current-dialogs*)
	  (refresh-environment)))

(defmacro real-current-dialog ()
  `(parent (car *current-dialogs*)))

(defmacro current-dialog ()
  `(car *current-dialogs*))

(defmacro push-panel (panel)
  `(prog1 (setq *current-panel* (get-form ,panel))
	  (refresh-environment)))

(defmacro pop-panel ()
  `(prog1 (setq *current-panel* nil)
	  (refresh-environment)))

(defmacro current-panel ()
  `*current-panel*)

(defmacro real-current-panel ()
  `(parent *current-panel*))

(defmacro push-frame (frame)
  `(prog1 (push (get-form ,frame) *current-frames*)
	  (refresh-environment)))

(defmacro pop-frame ()
  `(prog1 (pop *current-frames*)
	  (refresh-environment)))

(defmacro real-current-frame ()
  `(parent (car *current-frames*)))

(defmacro current-frame ()
  `(car *current-frames*))

(defmacro push-tool (tool)
  `(prog1 (setq *current-tool* ,tool)
	  (refresh-environment)))

(defmacro pop-tool ()
  `(prog1 (setq *current-tool* nil)
	  (refresh-environment)))

(defmacro current-tool ()
  `*current-tool*)


(defmacro ret-tool (&optional (retval nil))
  `(leave (current-tool) ,retval))

(defmacro exit-tool (&optional (retval nil))
  `(leave (current-tool) ,retval))

(defmacro ret-frame (&optional (retval nil))
  `(leave (current-frame) ,retval))

(defmacro ret-form (&optional (retval nil))
  `(leave (current-form) ,retval))

(defmacro ret-dialog (&optional (retval nil))
  `(leave (current-dialog) ,retval))

(defmacro ret (self &optional (retval nil))
  `(do ((window ,self (parent window)))
       ((picasso-object-p window) (leave window ,retval))
       (when (root-window-p window)
	     (warn "ret:  called from outside any picasso object")
	     (return))))

(defun clear-env ()
  (setq *starting-po-list* nil)
  (setq *current-tool* nil)
  (setq *current-frames* nil)
  (setq *current-dialogs* nil)
  (setq *current-panel* nil)
  (clrhash *global-dict*)
  (format t "Picasso environment cleared, proceed to reload tool.~%"))

