;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/type-macros.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/17 20:15:19 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;; macros to determine if an object is an instance of the specified class
;;;

(defmacro button-p (self)
  "determine if this object is a button"
  `(typep ,self 'button))

(defmacro color-p (self)
  "determine if this object is a color"
  `(typep ,self 'color))

(defmacro colormap-p (self)
  "determine if this object is a color"
  `(typep ,self 'colormap))

(defmacro cursor-p (self)
  "determine if this object is a cursor"
  `(typep ,self 'cursor))

(defmacro display-p (self)
  "determine if this object is an display"
  `(typep ,self 'display))

(defmacro screen-p (self)
  "determine if this object is an display"
  `(typep ,self 'screen))

(defmacro font-p (self)
  "determine if this object is a font"
  `(typep ,self 'font))

(defmacro locator-p (self)
  "determine if this object is of the class"
  `(typep ,self 'locator))

(defmacro opaque-window-p (self)
  "determine if this object is an opaque-window"
  `(typep ,self 'opaque-window))

(defmacro image-p (self)
  "determine if this object is a pixmap"
  `(typep ,self 'image))

(defmacro tile-p (self)
  "determine if this object is a pixmap"
  `(typep ,self 'tile))

(defmacro root-window-p (self)
  "determine if this object is an root-window"
  `(typep ,self 'root-window))

(defmacro text-window-p (self)
  "determine if this object is a text-window"
  `(typep ,self 'text-window))

(defmacro title-bar-p (self)
  "determine if this object is a title-bar"
  `(typep ,self 'title-bar))

(defmacro tool-window-p (self)
  "determine if this object is a tool-window"
  `(typep ,self 'tool-window))

(defmacro transparent-window-p (self)
  "determine if this object is a transparent-window"
  `(typep ,self 'transparent-window))

(defmacro x-window-p (self)
  "determine if this object is a x-window"
  `(typep ,self 'x-window))

(defmacro gadget-p (self)
  "determine if this object is a gadget"
  `(typep ,self 'gadget))

(defmacro null-gadget-p (self)
  "determine if this object is a null-gadget"
  `(typep ,self 'null-gadget))

(defmacro round-button-gadget-p (self)
  "determine if this object is a round-button-gadget"
  `(typep ,self 'round-button-gadget))

(defmacro text-gadget-p (self)
  "determine if this object is a text-gadget"
  `(typep ,self 'text-gadget))

(defmacro window-p (self)
  "determine if this object is a window"
  `(typep ,self 'window))

(defmacro widget-p (self)
  "determine if this object is a bitmap"
  `(typep ,self 'widget))

(defmacro collection-p (self)
  "determine if this object is a collection"
  `(typep ,self 'collection-gadget))

(defmacro bordered-p (win)
  "Tests if a window has a border"
  `(not (null (slot-value ,win 'border-type))))

(defmacro labeled-p (win)
  "Tests if a window has a label"
  `(not (null (slot-value ,win 'label))))

(defmacro variable-holder-p (self)
  "determine if this object is a variable holder"
  `(typep ,self 'variable-holder))

(defmacro picasso-object-p (self)
  "determine if this object is a picasso-object"
  `(typep ,self 'picasso-object))

(defmacro variable-p (self)
  "determine if this object is a variable"
  `(typep ,self 'variable))
