;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/appl-macros.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/17 20:14:56 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

(defmacro picasso-name-p (name)
  `(not (eq (name-type ,name) :error)))

(defmacro var-value-form-p (var)
  `(and (listp ,var) (eql (length ,var) 2) (eq (car ,var) 'value)))

(defmacro resolve-po (place)
  (let ((pl (eval place)))
       (cond ((typep pl 'picasso-object) `',pl)
	     ((picasso-name-p pl) `(find-picasso-object-named ',pl))
	     (t (setq pl (eval pl))
		(cond ((typep pl 'picasso-object) `',pl)
		      ((picasso-name-p pl) `(find-picasso-object-named ',pl))
		      (t (error "Bad picasso-object form")))))))

(defmacro resolve-and-set-po (place)
  (let ((pl (eval place)))
       (cond ((typep pl 'picasso-object) `',pl)
	     ((picasso-name-p pl) 
	      (eval `(setf ,place (find-picasso-object-named ',pl)))
	      (eval place))
	     (t (setq pl (eval pl))
		(cond ((typep pl 'picasso-object) `',pl)
		      ((picasso-name-p pl) `(find-picasso-object-named ',pl))
		      (t (error "Bad picasso-object form")))))))

(defmacro link (variable)
  `(progn
    (unless (var-value-form-p ',variable)
	    (error "link:  passed non variable form ~S" ',variable))
    (if (picasso-name-p ,variable)
	(setf ,variable (find-picasso-object-named ,variable)))))

(defmacro colonize (sym)
  `(pcl::make-keyword ,sym))

(defmacro remove-quote (thing)
  `(if (and (consp ,thing) (eq (car ,thing) 'quote))
       (setq ,thing (cadr ,thing))))

