;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: seitz $
;;; $Source: RCS/frame-label.cl,v $
;;; $Revision: 1.4 $
;;; $Date: 90/07/31 14:33:29 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;; a frame label is designed to fit inside a frame border

(defmethod label-init ((label (eql :frame)) self &aux atts gc) 
  (setq atts (slot-value self 'label-attributes))
  (unless (getf atts :foreground)
	  (setf (getf atts :foreground) "black"))
  (unless (getf atts :background)
	  (setf (getf atts :background) "white"))
  (unless (getf atts :font)
	  (setf (getf atts :font) "6x10"))
  (setf (slot-value self 'intern-label-gc)
	(setq gc
	      (make-shared-gc (parent self) atts)))
  (setf (slot-value self 'label-x) 10
	(slot-value self 'label-y) (- (font-descent nil gc))))

(defmethod label-repaint ((label (eql :frame)) self &aux gc sup lab)
  (setq gc (slot-value self 'intern-label-gc)
	sup (parent self))
  (when (stringp (setq lab (label self)))
	(xlib:draw-image-glyphs (res sup) gc 
				(+ (repaint-x sup) (x-offset self)
						      (label-x self))
				(+ (repaint-y sup) (y-offset self)
						      (label-y self))
				lab)))

(defmethod label-clear ((label (eql :frame)) self &aux sup gc)
  (setq sup (parent self)
	gc (slot-value self 'intern-label-gc))
  (clear-region sup
		(+ (repaint-x sup) (x-offset self) (label-x self))
		(+ (repaint-y sup) (y-offset self) (label-y self)
		   (- (font-height nil gc)))
		(text-width (label self) :gc gc)
		(font-height nil gc)))

(defmethod label-left-pad ((label (eql :frame)) self &rest args)
  (declare (ignore args))
  (- (label-x self)))

(defmethod label-bottom-pad ((label (eql :frame)) self 
			     &key height &allow-other-keys)
  (if (null height)
      (setq height (height self)))
  (max 0 (- (label-y self) height)))

(defmethod label-pad ((label (eql :frame)) self &rest args)
  (declare (ignore args))
  (values (- (label-x self)) 0 0 (max 0 (- (label-y self) (height self)))))
