;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: seitz $
;;; $Source: RCS/root-gm.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 90/07/23 16:05:50 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;  null-gm is a simple geometry manager which merely handles resizing 
;;;  children to their base sizes.

(defmethod gm-initialize ((gm (eql 'root-gm)) self)
  (setf (slot-value self 'gm-data) nil))

(defmethod gm-add-child ((gm (eql 'root-gm)) self child)
  (push child (slot-value self 'children))
  (if (managed-p child)
      (do-repack self)))

(defmethod gm-delete-child ((gm (eql 'root-gm)) self child)
  (setf (slot-value self 'children) (delete child (children self)))
  (if (managed-p child)
      (do-repack self)))

(defmethod gm-resize-hint-changed ((gm (eql 'root-gm)) self child)
  (if (managed-p child)
      (do-repack self)))

(defmethod gm-status-changed ((gm (eql 'root-gm)) self child)
  (if (not (x-window-p child))
      ;; Don't have to do anything if child is x-window -- server will call us
      ;; Child is not x-window. If child is newly expose, just repaint it,
      ;; otherwise, repaint ourselves to fill in hole.
      (if (exposed-p child)
	  (repaint child)
	  (let* ((x (x-offset child))
		 (y (y-offset child))
		 (bd (border-width child))
		 (bdw nil)
		 (bdh nil)
		 (w nil)
		 (h nil))
		(if (listp bd)
		    (setq bdw (+ (first bd) (third bd))
			  bdh (+ (second bd) (fourth bd)))
		    (setq bdw 
			  (setq bdh (+ bd bd))))
		(setq w (+ (width child) bdw)
		      h (+ (height child) bdh))
		(repaint-region self x y w h)))))

(defmethod gm-spec-changed ((gm (eql 'root-gm)) self child)
  (declare (ignore self child))
   t)

(defmethod gm-changed ((gm (eql 'root-gm)) self (old-gm (eql 'root-gm)))
  (gm-initialize gm self)
  (do-repack self))

(defmethod gm-data-changed ((gm (eql 'root-gm)) self old-data)
  (declare (ignore self old-data))
  t)

(defmethod gm-calculate-min-size ((gm (eql 'root-gm)) self)
  (let* ((max-w 0)
	 (max-h 0))
	(dolist (ch (managed-of (children self)))
		(setq max-w (max max-w (+ (x-offset ch) 
					  (if (zerop (base-width ch))
					      (width ch)
					      (base-width ch)))))
		(setq max-h (max max-h (+ (y-offset ch) 
					  (if (zerop (base-height ch))
					      (height ch)
					      (base-height ch))))))
	(setf (min-size self) (list max-w max-h))))

(defun root-shape (self width height &aux res)
  (when (and (eq width (slot-value self 'width))
	     (eq height (slot-value self 'height)))
	(return-from root-shape))
  (setf (slot-value self 'width) width
	(slot-value self 'height) height)
  (setq res (res self))
  (if (window-attached-p self)
      (xlib:with-state (res)
		       (setf (xlib:drawable-width res) width
			     (xlib:drawable-height res) height)))
  (if (pended-p self) (unpend self) (resize-window-handler self)))

(defmethod gm-repack ((gm (eql 'root-gm)) self &aux x y bw bh wi hi)
  (let* ((width (width self))
	 (height (height self)))
	(dolist (ch (managed-of (children self)))
		(multiple-value-setq (x y)
				     (xlib:translate-coordinates
				      (res ch) 0 0 (res self)))
		(setq bw (base-width ch)
		      bh (base-height ch)
		      wi (width-increment ch)
		      hi (height-increment ch))
		(root-shape ch
			    (round 
			     (if (zerop wi) bw
				 (min (- width x)
				      (max (width ch) bw))))
			    (round
			     (if (zerop hi) bh
				 (min (- height y)
				      (max (height ch) bh))))))
	(repaint self)))

