;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: RCS/gm-macros.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 90/07/26 14:13:35 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;; Macros for geometry maagement and collections.
;;;

(defmacro repack-off (collection)
  "Turn repacking off for a collection."
  `(setf (repack-flag ,collection) nil))

(defmacro repack-on (collection)
  "Turn repacking on for a collection and repack it."
  `(unless (repack-flag ,collection)
	   (setf (slot-value ,collection 'repack-flag) t)
	   (repack ,collection)))

(defmacro post-force-repack (self)
  "Repack all collections of the children that need repacking."
  `(mapc #'force-repack-needy-collections (children ,self)))

(defmacro post-repack (self)
  "Repack all collections of the children that need repacking."
  `(mapc #'repack-needy-collections (children ,self)))

(defmacro do-repack (self)
  "Do a repack if we're both exposed and repacking is on."
  `(if (and (repack-flag ,self) (exposed-p ,self))
       (let ((rc (repack-count ,self)))
	    (min-size ,self)
	    (unless (> (repack-count ,self) rc)
		    (gm-repack (gm ,self) ,self)
		    (post-repack ,self)
		    (setf (slot-value ,self 'repack-needed) nil)
		    (incf (repack-count ,self))))
       (setf (slot-value ,self 'repack-needed) t)))


(defmacro repack (self)
  "Do a repack if we need it."
  `(if (repack-needed ,self) (do-repack ,self)))

(defmacro force-repack (self)
  "Force a repack no matter what!"
  `(progn
    (min-size ,self)
    (gm-repack (gm ,self) ,self)
    (post-force-repack ,self)
    (setf (slot-value ,self 'repack-needed) nil)
    (incf (repack-count ,self))))


(defmacro just-repack (self)
  "Repack if needed, but do'nt recalc min size."
  `(if (and (repack-flag ,self) (exposed-p ,self))
       (progn
	(gm-repack (gm ,self) ,self)
	(post-repack ,self)
	(setf (repack-needed ,self) nil)
	(incf (repack-count ,self)))
       (setf (repack-needed ,self) t)))

(defmacro initialize-gm (self)
  "Initialize a collection for a (new) geometry manager"
  `(gm-initialize (gm ,self) ,self))

(defmacro add-child (self child)
  "Add a child to a geometry manager"
  `(progn
    (setf (min-size ,self) nil)
    (gm-add-child (gm ,self) ,self ,child)))
  
(defmacro delete-child (self child)
  "Delete a child from a geometry manager"
  `(progn
    (setf (min-size ,self) nil)
    (gm-delete-child (gm ,self) ,self ,child)))

(defmacro calculate-min-size (self)
  "Recalculate the minimum size for a collection"
  `(gm-calculate-min-size (gm ,self) ,self))

