;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: seitz $
;;; $Source: RCS/utils.cl,v $
;;; $Revision: 1.3 $
;;; $Date: 90/07/25 18:31:59 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;;	Functions to draw gray text (pass in window and gc clx resources)
;;;
(defun draw-gray-text (win gc str x y w h)
  (xlib:draw-rectangle win gc x y w h t)
  (xlib:draw-glyphs win gc x y str)
  (xlib:draw-rectangle win gc x y w h t))

(defun draw-gray-text-mask (win gc str x y w h)
  (xlib:draw-rectangle win gc x y w h t)
  (xlib:draw-image-glyphs win gc x y str)
  (xlib:draw-rectangle win gc x y w h t))

(defun draw-gray-image (win gc im x y &key (src-x 0) (src-y 0) w h 
			    (bitmap-p t))
  (unless w (setq w (xlib:image-width im)))
  (unless h (setq h (xlib:image-height im)))
  (xlib:draw-rectangle win gc x y w h t)
  (xlib:put-image win gc im :x x :y y :src-x src-x :src-y src-y
		  :width w :height h :bitmap-p bitmap-p)
  (xlib:draw-rectangle win gc x y w h t))

;;;
;;;	Functions to draw wild gray borders
;;;

;;
;;	Draws "gray border" inside gadget
;;

(defun draw-gray-border (gad black-gc white-gc
			     &key (invert nil) (x-width nil) (y-width nil)
			     &aux color1 color2 double)
  (when (not (numberp x-width)) (setq x-width 2))
  (when (not (numberp y-width)) (setq y-width x-width))
  (setq double (if (and (> x-width 3) (> y-width 3)) t nil))
  (let* ((rx (repaint-x gad))
	 (ry (repaint-y gad))
	 (x (+ x-width rx))
	 (y (+ y-width ry))
	 (width (+ (- (slot-value gad 'width) x-width) rx))
	 (height (+ (- (slot-value gad 'height) y-width) ry))
	 (res (res gad)))
	(cond ((and invert double)
	       (setq color1 black-gc
		     color2 white-gc))
	      ((or invert double)
	       (setq color1 white-gc
		     color2 black-gc))
	      (t
	       (setq color1 black-gc
		     color2 white-gc)))
	
	;;	Draw outer-border
	
	(xlib:draw-segments res color1
			    (list (- x 2) (1+ height) (1+ width) (1+ height) 
				  (1- x) height width height 
				  (1+ width) (- y 2) (1+ width) (1+ height) 
				  width (1- y) width (1+ height))) 
	(xlib:draw-segments res color2
			    (list (- x 2) (- y 2) (- x 2) (1+ height) 
				  (1- x) (1- y) (1- x) height 
				  (1- x) (1- y) width (1- y) 
				  (- x 2) (- y 2) (1+ width) (- y 2))) 
	
	(when double
	      ;;	Draw additional surrounding border
	      
	      (draw-inner-border gad black-gc white-gc rx ry
				 (+ width x-width) 
				 (+ height y-width) 
				 :invert invert))))
	       
;;;
;;; Draw a "3d" border with upper left at x,y of width w and height h
;;;

(defun draw-3d-border (win black-gc white-gc x y w h 
			   &key (invert nil) 
			   &aux res color1 color2)
  (cond (invert
	 (setq color1 black-gc
	       color2 white-gc))
	(t
	 (setq color1 white-gc
	       color2 black-gc)))
  
  (setq res (res win))
  
  ;; Offset to x-window coordinates...
  (incf x (repaint-x win))
  (incf y (repaint-y win))
  
  ;;; Draw top & left...
  (xlib:draw-rectangles res color1
			(list x y w 2
			      x y 2 h) t)
  ;; Draw bottom & right...
  (xlib:draw-rectangles res color2
			(list (1+ x) (+ y h -2) (1- w) 2
			      x (+ y h -1) 1 1
			      (+ x w -2) (1+ y) 2 (1- h)
			      (+ x w -1) y 1 1)
			t))


;;
;;	Draws a half-white/half black border of 2 pixel width
;;

(defun draw-inner-border (gad black-gc white-gc x y x2 y2 
			      &key (invert nil) 
			      &aux color1 color2 res)
  (cond (invert
	 (setq color1 white-gc
	       color2 black-gc))
	(t
	 (setq color1 black-gc
	       color2 white-gc)))
  (setq res (res gad))
  
  (xlib:draw-segments res color1
		      (list x y2 x2 y2
			    (1+ x) (1- y2) x2 (1- y2) 
			    x2 y x2 y2
			    (1- x2) (1+ y) (1- x2) (1- y2)))
  (xlib:draw-segments res color2
		      (list x y x y2 
			    (1+ x) (1+ y) (1+ x) (1- y2) 
			    x y x2 y 
			    (1+ x) (1+ y) (1- x2) (1+ y))))

;;
;;	Draws surrounding border outside window
;;

(defun draw-outer-border (win black-gc white-gc
			      &key (invert nil) (x-width nil) (y-width nil)
			      (fill-gc nil)
			      &aux color1 color2 double res)
  (when (not (numberp x-width)) (setq x-width 2))
  (when (not (numberp y-width)) (setq y-width x-width))
  (setq double (if (and (> x-width 3) (> y-width 3)) t nil))
  (let* ((sup (parent win))
	 (x (+ (repaint-x sup) (x-offset win)))
	 (y (+ (repaint-y sup) (y-offset win)))
	 (w (width win))
	 (h (height win))
	 (width (+ w x))
	 (height (+ h y)))
	(cond ((and invert double)
	       (setq color1 black-gc
		     color2 white-gc))
	      ((or invert double)
	       (setq color1 white-gc
		     color2 black-gc))
	      (t
	       (setq color1 black-gc
		     color2 white-gc)))
	
	(if sup
	    (setq res (res sup))
	    (progn 
	     (warn "draw-outer-border: couldn't draw border for ~S." win)
	     (return-from draw-outer-border)))

	;;	Fill border
	(when fill-gc 
	      (xlib:draw-rectangles 
	       res fill-gc 
	       (list (- x x-width) (- y y-width) x-width (+ h y-width)
		     x (- y y-width) (+ w x-width) y-width
		     (+ x w) y x-width (+ h y-width)
		     (- x x-width) (+ y h) (+ w x-width) y-width) t))

	;;	Draw outer-border
	
	(xlib:draw-segments res color1
			    (list 
			     (- x 2) (1+ height) (1+ width) (1+ height) 
				  (1- x) height width height 
				  (1+ width) (- y 2) (1+ width) (1+ height) 
				  width (1- y) width (1+ height)))

	(xlib:draw-segments res color2
			    (list (- x 2) (- y 2) (- x 2) (1+ height) 
				  (1- x) (1- y) (1- x) height 
				  (1- x) (1- y) width (1- y) 
				  (- x 2) (- y 2) (1+ width) (- y 2)))
	
	(when double
	      ;;	Draw additional outer border
	      (draw-inner-border sup black-gc white-gc 
				 (- x x-width) (- y y-width) 
				 (+ width x-width -1) 
				 (+ height y-width -1) 
				 :invert (if invert t nil)))))
