;;; 
;;; Copyright (c) 1990 Regents of the University of California
;;;
;;; $Author: picasso $
;;; $Source: RCS/low.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/17 19:57:50 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;; Picasso library functions
;;;

(defconstant *library-pathname*
  (make-pathname :directory "~picasso/lib/bitmaps/"))

(defun find-library-file (file)
  ;; concatenate library pathname w/ file
  (let ((*default-pathname-defaults* *library-pathname*))
    ;; test if file exists
    (probe-file file)))

;;;
;;; keyword/value mapping utilities
;;;

(defvar *keyword-value-table* nil "hash table to bind values to keywords")

;;;
;;; symbol/event mapping utilities
;;;

(defvar *symbol-event-table* nil "hash table to bind symbols to xcl event ids")

#|(defconstant *symbol-event-list* 
  (list (list 'no-event xcl:*no-event* )
	(list 'key-pressed xcl:*key-pressed* )
	(list 'key-released xcl:*key-released* )
	(list 'button-pressed xcl:*button-pressed* )
	(list 'double-click xcl:*button-pressed* )
	(list 'triple-click xcl:*button-pressed* )
	(list 'button-released xcl:*button-released* )
	(list 'enter-window xcl:*enter-window* )
	(list 'leave-window xcl:*leave-window* )
	(list 'mouse-moved xcl:*mouse-moved* )
	(list 'expose-window xcl:*expose-window* )
	(list 'expose-region xcl:*expose-region* )
	(list 'expose-copy xcl:*expose-copy* )
	(list 'double-click xcl:*double-click* )
	(list 'triple-click xcl:*triple-click* )
	(list 'right-down-motion xcl:*right-down-motion* )
	(list 'middle-down-motion xcl:*middle-down-motion* )
	(list 'left-down-motion xcl:*left-down-motion* )
	(list 'conceal-window xcl:*unmap-window* )
	(list 'focus-change xcl:*focus-change* )
	(list 'all-events xcl:*all-events* )))|#

#|(eval-when (eval load)
  ;; Initialize the symbol-event-table
  (setq *symbol-event-table* (make-hash-table))
  (dolist (kv *symbol-event-list*)
	  ;; add pair
	  (setf (gethash (first kv) *symbol-event-table*) (second kv))))|#

#|(defun append-symbol-event (symbol xcl-id)
  ;; add binding to hash table
  (setf (gethash symbol *symbol-event-table*) xcl-id))|#

#|(defun symbol-event (symbol)
  "return the xcl event id of the specified symbol"
  ;; lookup value in symbol-event table; return nil if bogus
  (gethash symbol *symbol-event-table*))|#

;;;
;;; Change print function to print out named objects better.
;;;

(defun pcl::printing-random-thing-internal (thing stream)
  (if (and (slot-exists-p thing 'pt::name)
	   (slot-boundp thing 'pt::name))
      (format stream "~s" (slot-value thing 'pt::name))
      (format stream "~O" (excl::pointer-to-fixnum thing))))
