;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/shadow-border.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/17 19:50:58 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;; a shadow border is a drop-shadow

(defmethod border-init ((border (eql :shadow)) self)
  (setf (xlib:drawable-border-width (res self)) 0)
  (setf (slot-value self 'intern-border-gcs) 
	(make-shared-gc (parent self) '(:paint "gray25")))
  (setf (slot-value self 'border-width) '(0 0 7 7)))

(defmethod border-repaint ((border (eql :shadow)) self 
			   &aux gcs b bw bh x y w h rx ry sup)
  (setq gcs (slot-value self 'intern-border-gcs)
	b (slot-value self 'border-width)
	sup (parent self))
  (if (listp b) 
      (setq bw (third b) bh (fourth b))
      (setq bw b bh b))
  (setq x (x-offset self)
	y (y-offset self)
	w (width self)
	h (height self)
	rx (repaint-x (parent self))
	ry (repaint-y (parent self)))
  (xlib:draw-rectangles (res sup) (slot-value self 'intern-border-gcs)
			(list (+ rx x w) (+ ry y 5) bw (- h 5)
			      (+ rx x 5) (+ ry x h) (- w 5 (- bw)) bh)
			t))

(defmethod border-clear ((border (eql :shadow)) self
			 &aux b bw bh sup)
  (setq b (slot-value self 'border-width)
	sup (parent self))
  (if (listp b) 
      (setq bw (third b) bh (fourth b))
      (setq bw b bh b))
  (clear-region (parent self) 
		(+ (repaint-x sup) (x-offset self) 5) 
		(+ (repaint-y sup) (y-offset self) 5) 
		(+ (width self) -5 bw) (+ (height self) -5 bh)))
