;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/inset-border.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/17 19:50:46 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;; a inset border makes something look inset in the window

(defmethod border-init ((border (eql :inset)) self &aux sup) 
  (setq sup (parent self))
  (setf (xlib:drawable-border-width (res self)) 0)
  (setf (slot-value self 'intern-border-gcs) 
	(cons (make-shared-gc sup '(:background "white" :foreground "black"))
	      (make-shared-gc sup '(:foreground "white"))))
  (setf (slot-value self 'border-width) 2))

(defmethod border-repaint ((border (eql :inset)) self 
			   &aux gcs bw w h sup label)
  (setq gcs (slot-value self 'intern-border-gcs)
	bw (slot-value self 'border-width)
	sup (parent self))
  (if (listp bw) 
      (setq w (car bw) h (cadr bw))
      (setq w bw h bw))
  (draw-outer-border self (cdr gcs) (car gcs) :x-width w :y-width h))

(defmethod border-clear ((border (eql :inset)) self &aux bw x y w h sup)
  (setq bw (border-width self)
	sup (parent self))
  (if (listp bw) 
      (setq x (car bw) y (cadr bw) w (third bw) h (fourth bw))
      (setq x bw y bw w bw h bw))
  (clear-region (parent self) 
		(+ (repaint-x sup) (x-offset self) (- x))
		(+ (repaint-y sup) (y-offset self) (- y))
		(+ (width self) x w)
		(+ (height self) y h)))
