;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/frame-border.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/17 19:50:41 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;; a frame border looks something like a picture frame

(defmethod border-init ((border (eql :frame)) self &aux sup atts gc) 
  (setq sup (parent self))
  (setf (xlib:drawable-border-width (res self)) 0)
  (setq atts (border-attributes self))
  (when (setq gc (getf atts :background))
	(setq gc (make-shared-gc sup (list :foreground gc))))
  (setf (slot-value self 'intern-border-gcs) 
	(list (make-shared-gc sup '(:background "white" :foreground "black"))
	      (make-shared-gc sup '(:foreground "white"))
	      gc))
  (setf (slot-value self 'border-width) 7))

(defmethod border-repaint ((border (eql :frame)) self &aux gcs bw w h sup)
  (setq gcs (slot-value self 'intern-border-gcs)
	bw (slot-value self 'border-width)
	sup (parent self))
  (if (listp bw) 
      (setq w (car bw) h (cadr bw))
      (setq w bw h bw))
  (draw-outer-border self (car gcs) (cadr gcs) :x-width w :y-width h 
		     :fill-gc (third gcs)))

(defmethod border-clear ((border (eql :frame)) self &aux bw x y w h sup)
  (setq bw (border-width self)
	sup (parent self))
  (if (listp bw) 
      (setq x (car bw) y (cadr bw) w (third bw) h (fourth bw))
      (setq x bw y bw w bw h bw))
  (clear-region (parent self) 
		(+ (repaint-x sup) (x-offset self) (- x))
		(+ (repaint-y sup) (y-offset self) (- y))
		(+ (width self) x w 2)
		(+ (height self) y h 2)))
