;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: seitz $
;;; $Source: RCS/box-border.cl,v $
;;; $Revision: 1.3 $
;;; $Date: 90/07/27 15:33:04 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;; a box border is simply a black rectangle around the window

(defmethod border-init ((border (eql :box)) self &aux atts bg)
  (when (not (opaque-window-p self))
	(setq atts (border-attributes self))
	(when (setq bg (getf atts :background))
	      (remf atts :background)
	      (setf (getf atts :paint) bg))
      (setf (slot-value self 'intern-border-gcs)
	    (make-shared-gc (parent self) atts))))

(defmethod border-resize ((border (eql :box)) self)
  (when (opaque-window-p self)
	(setf (xlib:drawable-border-width (res self))
	      (slot-value self 'border-width))))

(defmethod border-repaint ((border (eql :box)) self 
			   &aux bw lbw tbw rbw bbw rx ry x y w h sup)
  (unless (opaque-window-p self)
	  (setq sup (parent self)
		bw (border-width self))
	  (if (listp bw)
	      (setq lbw (first bw)
		    tbw (second bw)
		    rbw (third bw)
		    bbw (fourth bw))
	      (setq lbw bw
		    tbw bw
		    rbw bw
		    bbw bw))
	  (setq x (x-offset self)
		y (y-offset self)
		w (width self)
		h (height self))
	  (setq rx (+ (repaint-x sup) x)
		ry (+ (repaint-y sup) y))
	  (xlib:draw-rectangles (res self) (slot-value self 'intern-border-gcs)
				(list rx (- ry tbw) (+ w rbw) tbw
				      (- rx lbw) (- ry lbw) lbw (+ h tbw)
				      (+ rx w) ry rbw (+ h bbw)
				      (- rx lbw) (+ ry h) (+ w lbw) bbw)
				t)))

(defmethod border-clear ((border (eql :box)) self
			 &aux bw x y w h sup)
  (setq bw (border-width self)
	sup (parent self))
  (if (listp bw)
      (setq x (car bw) y (cadr bw) w (third bw) h (fourth bw))
      (setq x bw y bw w bw h bw))
  (clear-region sup 
		(+ (repaint-x sup) (x-offset self) (- x))
		(+ (repaint-y sup) (y-offset self) (- y))
		(+ (width self) x w)
		(+ (height self) y h)))
