;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/synths.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 90/07/17 19:35:03 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;;	Assorted macros that work on synthetic gadgets.  Titles are
;;;	analogous to similar macros on windows.  A synthetic gadget is
;;;	a list where the first element is a displayable object (via
;;;	a put method) or a list of displayable objects and the following
;;;	elements are keyword/value pairs.

(defmacro synth-p (obj)
  "Return t if obj is a synthetic-gadget, nil otherwise"
  `(and (listp ,obj) 
	(or (= (length ,obj) 1)
	    (keywordp (cadr ,obj)))))

(defmacro synth-exposed-p (synth)
  "Return whether the synthetic gadget is exposed (visible on screen)."
  `(getf ,synth :exposed))

(defmacro exposed-synths-of (synth-list)
  "Return a list of exposed synthetic gadgets"
  `(mapcan #'(lambda (ch) (if (synth-exposed-p ch) (list ch))) ,synth-list))

(defmacro synth-width (synth)
  "Return the 'desired' width of the synthetic gadget"
  `(let ((val (car ,synth)))
	(cond ((stringp val)
	       (let ((font (getf (cdr ,synth) :font)))
		    (cond ((font-p font))
			  ((stringp font) 
			   (setq font (get-font font)))
			  ((null font)
			   (setq font (get-font))))
		    (text-width val :font font)))
	      ((not (listp val))
	       (width val))
	      ((null val) 0)
	      #|(t (apply #'+ 
			(mapcar #'(lambda (x) (intern-synth-width 
					       (cons x (cdr val))))
				val)))|#
	      (t (error "synth-width: can't compute width of list \`~s\`" val))
	      )))

(defun intern-synth-width (synth)
  (synth-width synth))

(defmacro synth-height (synth)
  "Return the 'desired' height of the synthetic gadget"
  `(let ((val (car ,synth)))
	(cond ((stringp val)
	       (let ((font (getf (cdr ,synth) :font)))
		    (cond ((font-p font))
			  ((stringp font) 
			   (setq font (get-font font)))
			  ((null font)
			   (setq font (get-font))))
		    (font-height font)))
	      ((not (listp val))
	       (height val))
	      ((null val) 0)
	      #|(t (apply #'+ 
			(mapcar #'(lambda (x) (intern-synth-height 
					       (cons x (cdr val))))
				val)))|#
	      (t (error "synth-height: can't compute width of list \`~s\`" val))
	      )))

(defun intern-synth-height (synth)
  (synth-height synth))

(defun synth-execute (slot object &optional (event nil))
  (push-env (getf object :window))
  (eval
   `(let ((self ',object)
	  (event ',event))
	 ,(getf object (if (keywordp slot) slot (pcl::make-keyword slot)))))
  (pop-env))
