;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: RCS/collection-gadget-def.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 90/07/26 14:38:39 $
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;; gadget class
;;;
(defclass collection-gadget (gadget) 
  ((name :initform "A Collection") 
   (value :type t :initform "Collection" :reader value)
   (gm :type atom :initarg :gm  :initform 'null-gm :accessor gm)
   (gc-spec :initform nil)
   (children :type t :initarg :children  :initform nil :accessor children)
   (label-type :initform nil)
   (repack-flag 
    :type atom 
    :initarg :repack-flag  
    :initform nil 
    :reader repack-flag)
   (repack-needed 
    :type atom 
    :initarg :repack-needed  
    :initform nil 
    :accessor repack-needed)
   ;;; conform is one of :dont-conform :grow-only and :grow-shrink
   (conform 
    :type atom 
    :initarg :conform  
    :initform :grow-shrink 
    :reader conform)
   (repack-count :type integer :initform 0 :accessor repack-count)
   (min-size :type list :initform nil :accessor min-size)
   (gm-data :type t :initform nil :accessor gm-data)))

(defun make-collection-gadget (&rest keys)
  (apply #'make-instance 'collection-gadget :allow-other-keys t keys))

(defun force-repack-needy-collections (self)
  (when (collection-p self)
	(force-repack self)
	(post-force-repack self)))

(defun repack-needy-collections (self)
  (when (collection-p self)
	(repack self)
	(post-repack self)))

(defmethod (setf gm) (value (self collection-gadget))
  (let ((oldgm (gm self)))
       (setf (slot-value self 'gm) value)
       (gm-changed value self oldgm)))

(defmethod (setf gm-data) (value (self collection-gadget))
  (let ((old-data (gm-data self)))
       (setf (slot-value self 'gm-data) value)
       (gm-data-changed (gm self) self old-data)))


(defmethod (setf repaint-flag) (value (self collection-gadget))
  (when (or (not value) (not (parent self)) (repaint-flag (parent self)))
	(setf (slot-value self 'repaint-flag) value)
	(dolist (ch (children self))
		(setf (repaint-flag ch) value))))

(defmethod (setf value) (value (self collection-gadget))
  (setf (slot-value self 'value) value))

(defmethod (setf repack-flag) (value (self collection-gadget))
  (unless (eql value (repack-flag self))
	  (setf (slot-value self 'repack-flag) value)
	  (if (and value (repack-needed self))
	      (repack self))))

(defmethod (setf conform) (value (self collection-gadget))
  (if (member value '(:dont-conform :grow-only :grow-shrink))
      (progn
       (setf (slot-value self 'conform) value)
       (resize-hint-changed self))
      (warn "collection-gadget.(setf conform):  Illegal value, ignored~%")))

(defmethod (setf min-size) (value (self collection-gadget))
  (if (null value) 
      (let ((prnt (parent self)))
	   (setf (slot-value self 'min-size) nil)
	   (if (and (window-p prnt) (not (root-window-p prnt)))
	       (setf (min-size prnt) nil)))
      (case (conform self)
	    (:dont-conform
	     (setf (slot-value self 'min-size) value))
	    (:grow-shrink
	     (let ((bs (static-base-size self))
		   (newbs nil))
		  (setf (slot-value self 'min-size) value)
		  (setf newbs (static-base-size self))
		  (unless (equal bs newbs)
			  (resize-hint-changed self))))
	    (:grow-only
	     (let ((bs (static-base-size self))
		   (newbs nil))
		  (setf (slot-value self 'min-size) 
			(mapcar #'max (static-min-size self) value))
		  (setf newbs (static-base-size self))
		  (unless (equal bs newbs)
			  (resize-hint-changed self))))
	    (otherwise 
	     (error "collection-gadget.(setf min-size):  illegal conform~%")))))
