;;;
;;; Picasso window system package
;;;
;;; Copyright (c) 1986 Regents of the University of California
;;; 
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 
;;; $Author: bsmith $
;;; $Source: RCS/sysdef.cl,v $
;;; $Revision: 1.6 $
;;; $Date: 90/07/26 17:17:45 $
;;;

(in-package 'pds :use '(lisp))

;;;
;;; Picasso version
;;;
(defconstant *picasso-version* '("$Revision: 1.6 $"))

;;;
;;; Add :picasso to the *features* list
;;;
(setf *features* (union *features* '( :picasso )))

;;; One of :test :release or :stable is on the features list

;;;
;;; Load named module
;;;
(defmacro load-module-named (name sys)
  `(load-module (find-module-named ,name ,sys)))

;;;
;;; Picasso defsystem
;;;	WARNING: If you modify this file, remake the sysdef.parsed file
;;;
(defsystem pt
  (:init-code (progn 
	       (let ((sys (find-system-named 'pt)))
		    (load-module-named "toolkit/etc/clos" sys)
		    (load-module-named "toolkit/picasso/var-macros" sys)
		    (load-module-named "toolkit/macros/macros" sys)
		    (load-module-named "toolkit/base/event-handler-def" sys)
		    (load-module-named "toolkit/picasso/code" sys)
		    (load-module-named 
                            "toolkit/picasso/lexical-stack" sys))
	       (unless (find-package 'pgclos) (make-package 'pgclos)))
	      :src-pathname "./"
	      :bin-pathname 
	      #+DEC3100        "../build/allegro/3100/"
	      #+sun3       "../build/allegro/sun3/"
	      #+sun4       "../build/allegro/sun4/"
	      #+(and mips (not DEC3100))      "../build/allegro/mips/"
	      #+sequent   "../build/allegro/sequent/")
;	      :src-pathname "/pic2/picasso/test/src/"
;	      :bin-pathname 
;	      #+DEC3100        "/pic2/picasso/test/build/allegro/3100/"
;	      #+sun3       "/pic2/picasso/test/build/allegro/sun3/"
;	      #+sun4       "/pic2/picasso/test/build/allegro/sun4/"
;	      #+(and mips (not DEC3100))      "/pic2/picasso/test/build/allegro/mips/"
;	      #+sequent   "/pic2/picasso/test/build/allegro/sequent/")
  
  ;;============== BASE TOOLKIT ==================================
  ("collection-gadget-def" :sub-directory "toolkit/base")
  ("collection-gadget-method" :sub-directory "toolkit/base")
  ("collection-widget" :sub-directory "toolkit/base")
  ("event" :sub-directory "toolkit/base")
  ("event-handler-def" :sub-directory "toolkit/base")
  ("event-handler-method" :sub-directory "toolkit/base")
  ("gadget" :sub-directory "toolkit/base")
  ("gc" :sub-directory "toolkit/base")
  ("opaque-window" :sub-directory "toolkit/base")
  ("root-window" :sub-directory "toolkit/base")
  ("synths" :sub-directory "toolkit/base"
	    :load-before-compile ("toolkit/macros/type-macros")
	    :load-after ("toolkit/macros/type-macros"))
  ("widget" :sub-directory "toolkit/base")
  ("window-def" :sub-directory "toolkit/base")
  ("window-method" :sub-directory "toolkit/base")
  ("x-window-def" :sub-directory "toolkit/base")
  ("x-window-method" :sub-directory "toolkit/base")

  ;;============== BORDERS =======================================
  ("black-frame-border" :sub-directory "toolkit/borders")
  ("box-border" :sub-directory "toolkit/borders")
  ("frame-border" :sub-directory "toolkit/borders")
  ("inset-border" :sub-directory "toolkit/borders")
  ("null-border" :sub-directory "toolkit/borders")
  ("shadow-border" :sub-directory "toolkit/borders")
  ("standout-border" :sub-directory "toolkit/borders")

  ;;============== UTILITY FILES =================================
  ("clos-portal" :sub-directory "toolkit/etc")
  ("clos" :sub-directory "toolkit/etc")
  ("low" :sub-directory "toolkit/etc")
  ("portal" :sub-directory "toolkit/etc")
  ("utils" :sub-directory "toolkit/etc")

  ;;============== GEOMETRY MANAGERS =============================
  ("anchor-gm" :sub-directory "toolkit/gm")
  ("gm-macros" :sub-directory "toolkit/gm"
	       :load-before-compile ("toolkit/base/collection-gadget-def"
				     "toolkit/macros/window-macros")
	       :load-after ("toolkit/base/collection-gadget-def"
			    "toolkit/macros/window-macros"))
  ("linear-gm" :sub-directory "toolkit/gm")
  ("matrix-gm" :sub-directory "toolkit/gm")
  ("null-gm" :sub-directory "toolkit/gm")
  ("packed-gm" :sub-directory "toolkit/gm")
  ("root-gm" :sub-directory "toolkit/gm")
  ("rubber-gm" :sub-directory "toolkit/gm")
  ("stacked-gm" :sub-directory "toolkit/gm")

  ;;============== LABELS ========================================
  ("bottom-label" :sub-directory "toolkit/label")
  ("default-label" :sub-directory "toolkit/label")
  ("frame-label" :sub-directory "toolkit/label")
  ("left-label" :sub-directory "toolkit/label")
  ("null-label" :sub-directory "toolkit/label")

  ;;============== MACROS ========================================
  ("appl-macros" :sub-directory "toolkit/macros")
  ("macros" :sub-directory "toolkit/macros")
  ("type-macros" :sub-directory "toolkit/macros")
  ("window-macros" :sub-directory "toolkit/macros")

  ;;============== PICASSO FRAMEWORK SUPPORT =====================
  ("code" :sub-directory "toolkit/picasso")
  ("lazy-eval" :sub-directory "toolkit/picasso")
  ("lexical-stack" :sub-directory "toolkit/picasso")
  ("object-id" :sub-directory "toolkit/picasso")
  ("picasso-dict" :sub-directory "toolkit/picasso")
  ("propagator" :sub-directory "toolkit/picasso")
  ("var-macros" :sub-directory "toolkit/picasso")
  ("variable" :sub-directory "toolkit/picasso")

  ;;============== X RESOURCE SUPPORT ============================
  ("color" :sub-directory "toolkit/resource")
  ("colormap" :sub-directory "toolkit/resource")
  ("cursor" :sub-directory "toolkit/resource")
  ("defaults" :sub-directory "toolkit/resource")
  ("display-text" :sub-directory "toolkit/resource")
  ("display" :sub-directory "toolkit/resource")
  ("font" :sub-directory "toolkit/resource")
  ("gif-utils" :sub-directory "toolkit/resource")
  ("icon" :sub-directory "toolkit/resource")
  ("image" :sub-directory "toolkit/resource")
  ("paint" :sub-directory "toolkit/resource")
  ("rgb-image" :sub-directory "toolkit/resource")
  ("screen" :sub-directory "toolkit/resource")
  ("text" :sub-directory "toolkit/resource")
  ("tile" :sub-directory "toolkit/resource")

  ;;===============SHARED OBJECT HIERARCHY========================
;;  ("defdbclass" :sub-directory "toolkit/soh")
;;  ("add-named-class" :sub-directory "toolkit/soh"
;;		     :load-before-compile ("defdbclass")
;;		     :load-after ("defdbclass")
;;		     :recompile-on ("defdbclass"))
;;  ("cache" :sub-directory "toolkit/soh"
;;		     :load-before-compile ("defdbclass")
;;		     :load-after ("defdbclass")
;;		     :recompile-on ("defdbclass"))
;;  ("dbobject" :sub-directory "toolkit/soh"
;;	             :load-before-compile ("defdbclass" "cache")
;;		     :load-after ("defdbclass")
;;		     :recompile-on ("defdbclass"))
;;  ("map" :sub-directory "toolkit/soh"
;;		     :load-before-compile ("defdbclass")
;;		     :load-after ("defdbclass")
;;		     :recompile-on ("defdbclass"))
;;  ("slots" :sub-directory "toolkit/soh"
;;	             :load-before-compile ("defdbclass" "cache")
;;		     :load-after ("defdbclass")
;;		     :recompile-on ("defdbclass"))
;;  ("exit" :sub-directory "toolkit/soh"
;;		     :load-before-compile ("cache")
;;		     :load-after ("cache")
;;		     :recompile-on ("cache"))
;;  ("fn-cache" :sub-directory "toolkit/soh")
;;  ("store" :sub-directory "toolkit/soh")



  
  ;;============== BUTTONS =======================================
  ("button" :sub-directory "widgets/button")
  ("click-button" :sub-directory "widgets/button")
  ("gray-button" :sub-directory "widgets/button")
  ("gray-pop-button" :sub-directory "widgets/button")
  ("pop-button" :sub-directory "widgets/button")
  ("swap-button" :sub-directory "widgets/button")
  
  ;;============== CHECK/RADIO BUTTONS ===========================
  ("button-group" :sub-directory "widgets/check-radio")
  ("check-button" :sub-directory "widgets/check-radio"
		  :load-before-compile ("toolkit/resource/image")
		  :load-after ("toolkit/resource/image"))
  ("check-group" :sub-directory "widgets/check-radio")
  ("radio-group" :sub-directory "widgets/check-radio")
  
  ;;============== UTILITY FILES =================================
  ("last" :sub-directory "widgets/etc")
  ("start-func" :sub-directory "widgets/etc")
  
  ;;============== APPLICATION FRAMEWORK =========================
  ("defPO" :sub-directory "widgets/framework")
  ("dialog" :sub-directory "widgets/framework")
  ("form" :sub-directory "widgets/framework")
  ("frame" :sub-directory "widgets/framework")
  ("panel" :sub-directory "widgets/framework")
  ("picasso-object" :sub-directory "widgets/framework")
  ("po-tables" :sub-directory "widgets/framework")
  ("po-type-macros" :sub-directory "widgets/framework")
  ("tool" :sub-directory "widgets/framework")
  
  ;;============== GRAPHIC DATA WIDGETS ==========================
  ("2d-bbox" :sub-directory "widgets/graphic")
  ("2d-shape" :sub-directory "widgets/graphic")
  ("2d-vector" :sub-directory "widgets/graphic")
  ("annot-dl" :sub-directory "widgets/graphic")
  ("annotation" :sub-directory "widgets/graphic")
  ("box" :sub-directory "widgets/graphic")
  ("display-list" :sub-directory "widgets/graphic")
  ("graphic-browser" :sub-directory "widgets/graphic")
  ("graphic-gadget" :sub-directory "widgets/graphic")
  ("grf-utils" :sub-directory "widgets/graphic")
  ("line-segment" :sub-directory "widgets/graphic")
  ("line-string" :sub-directory "widgets/graphic")
  ("map-float" :sub-directory "widgets/graphic")
  ("mapper" :sub-directory "widgets/graphic")
  ("plot-widget" :sub-directory "widgets/graphic")
  ("polygon" :sub-directory "widgets/graphic")
  ("rover-widget" :sub-directory "widgets/graphic")
  ("segment-dl" :sub-directory "widgets/graphic")
  ("segment" :sub-directory "widgets/graphic")
  ("shape" :sub-directory "widgets/graphic")
  ("sgg-data-utils" :sub-directory "widgets/graphic")
  ("sgg-gadget" :sub-directory "widgets/graphic")
  ("sgg-browser" :sub-directory "widgets/graphic")
  
  ;;============== BITMAP DATA WIDGETS ===========================
  ("image-gadget" :sub-directory "widgets/image")
  ("image-widget" :sub-directory "widgets/image")
  ("paint-gadget" :sub-directory "widgets/image")
  
  ;;============== MENU UTILITIES ================================
  ("menu-bar" :sub-directory "widgets/menu")
  ("menu-defclasses" :sub-directory "widgets/menu")
  ("menu-entry" :sub-directory "widgets/menu")
  ("menu-macros" :sub-directory "widgets/menu")
  ("menu-pane" :sub-directory "widgets/menu")
  ("menu" :sub-directory "widgets/menu")
  
  ;;============== MISC DATA WIDGETS =============================
  ("arb-widget" :sub-directory "widgets/misc")
  ("enclosure-widget" :sub-directory "widgets/misc")
  ("meter-widget" :sub-directory "widgets/misc")
  ("indicator-widget" :sub-directory "widgets/misc")
  ("indicator" :sub-directory "widgets/misc")
  ("qual-widget" :sub-directory "widgets/misc")
  ("scroll-bar" :sub-directory "widgets/misc")
  
  ;;============== TABLE WIDGETS ================================
  ("browse-widget" :sub-directory "widgets/table" 
		   :load-before-compile ("widgets/table/table-field")
		   :load-after ("widgets/table/table-field"))
  ("data-utils" :sub-directory "widgets/table"
		:load-before-compile ("toolkit/etc/clos-portal")
		:load-after ("toolkit/etc/clos-portal"))
  ("list-box" :sub-directory "widgets/table")
  ("list-of-str" :sub-directory "widgets/table")
  ("matrix-field-def" :sub-directory "widgets/table"
		      :load-before-compile ("toolkit/etc/clos-portal")
		      :load-after ("toolkit/etc/clos-portal"))
  ("matrix-field-methods" :sub-directory "widgets/table" 
			  :load-before-compile ("toolkit/etc/clos-portal")
			  :load-after ("toolkit/etc/clos-portal"))
  ("table-field" :sub-directory "widgets/table"
		 :load-before-compile ("widgets/table/matrix-field-def")
		 :load-after ("widgets/table/matrix-field-def"))
  ("table-utils" :sub-directory "widgets/table"
		 :load-before-compile ("widgets/table/table-field")
		 :load-after ("widgets/table/table-field"))
  ("tf-button" :sub-directory "widgets/table")
  
  ;;============== TEXT WIDGETS =================================
  ("buffer" :sub-directory "widgets/text")
  ("entry-widget" :sub-directory "widgets/text")
  ("num-entry" :sub-directory "widgets/text")
  ("scrollable-num-entry" :sub-directory "widgets/text")
  ("scrolling-text-widget" :sub-directory "widgets/text")
  ("text-buffer-gadget-defs" :sub-directory "widgets/text")
  ("text-buffer-gadget-methods" :sub-directory "widgets/text")
  ("text-gadget" :sub-directory "widgets/text")
  ("text-output-widget" :sub-directory "widgets/text")
  ("text-widget" :sub-directory "widgets/text"))
