;;; 
;;; Copyright (c) 1982 Regents of the University of California
;;; Copyright (c) 1987 Regents of the University of California
;;;
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 

(in-package 'sling :nicknames '(commonlisp-rtingres))

;;;
;;; Constants
;;;

(defconstant max-ingres-name-length 24)

;;;
;;; Global variables
;;;

(defvar time-in-cling 0)
(defvar ptime-in-cling 0)

(defvar current-db-name nil)
(defvar retrieve-in-progress nil)
(defvar show-query nil)

(defvar to-ingres t)
(defvar to-string nil)
(defvar write-out-string "")

;;;
;;; Increment the timers to keep an idea of how much time is being spent
;;; running this garbage.
;;; Is this really of interest?
;;;
(defmacro record-time (&rest body)
  `(let ((start-time (get-internal-real-time))
	 (start-ptime (get-internal-run-time))
	 (final-value (progn ,@body)))
	(setq time-in-cling		;### integer math will truncate this!
	      (+ time-in-cling (/ (- (get-internal-real-time) start-time)
				internal-time-units-per-second)))
	(setq ptime-in-cling
	      (+ ptime-in-cling
		 (/ (- (get-internal-run-time) start-ptime)
		    internal-time-units-per-second)))
	final-value))

;;;
;;; This is a call to IIwritio with an option to print the text to
;;; stdout for debugging and/or to a variable write-out-string.
;;;
(defmacro write-out (object)
  `(progn
	(if to-ingres
		(ii-writio 0 0 1 32 0 ,object))
	(if show-query
		(princ ,object))
	(if to-string
		(setq write-out-string
			  (concatenate 'string write-out-string ,object)))))

;;;
;;; This sends all write-out's to write-out-string and not to ingres.
;;; Clears write-out-string before new output is added.
;;;
(defmacro write-out-to-string (&rest body)
  `(let ((old-ti to-ingres)
		 (old-ts to-string))
		(unwind-protect
		 (progn
		  (setq to-ingres nil)
		  (setq to-string t)
		  (setq write-out-string "")
		  ,@body)
		 (setq to-ingres old-ti)
		 (setq to-string old-ts))))

;;;
;;; IIsyncup is called after everything except a retrieve that returns data
;;; to the user.
;;;
(defmacro end-command ()
  `(unless (nested-command-mode)
    (ii-syncup 0 0)
    (if show-query (terpri))
	(dispatch-whenever (sqlstatus sqlca-ptr))))

(defmacro listify (arg)
  `(if (listp ,arg)
    ,arg
    (list ,arg)))
